package com.vhall.business;


import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.ims.VHIM;
import com.vhall.lss.push.VHLivePusher;
import com.vhall.message.ConnectServer;
import com.vhall.player.Constants;

import org.json.JSONObject;

import java.util.List;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.module.chat.VssChatManager;
import vhall.com.vss2.module.room.VssRoomManager;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;

class BroadcastH5 extends Push {
    private static final String TAG = "BroadcastH5";
    //发直播
    private VHLivePusher mVhallPushLive;

    private ResponseRoomInfo roomInfo;

    private IVssCallBackListener iVssCallBackListener = new IVssCallBackListener() {
        @Override
        public void onStateChanged(ConnectServer.State state, int i) {
            //todo vss 层能否分开反馈
            switch (state) {
                case STATE_CONNECTED:
                    if (chatCallback != null) {
                        chatCallback.onChatServerConnected();
                    }
                    break;
                case STATE_CONNECTIONG:
                    //连接中
                    break;
                case STATE_DISCONNECT:
                    if (chatCallback != null) {
                        chatCallback.onChatServerClosed();
                    }
                    break;
                case STATE_KICK_OFF:
                    //用户链接的消息服务被踢出，无法继续接收消息。需要根据业务需求进行处理。
                    if(chatCallback != null){
                        chatCallback.onChatServerKickOff();
                    }
                    break;
                default:
                    break;
            }
        }

        @Override
        public void onError(int code, String msg) {
            //todo vss 层能否分开反馈
            if (chatCallback != null) {
                chatCallback.onConnectFailed();
            }
        }
    };

    @Override
    public void setWebinarInfo(final WebinarInfo webinarInfo) {
        if (webinarInfo == null) {
            if (listener != null) {
                listener.onError(ERROR_NOT_INIT, 0, "error data");
            }
            return;
        }
        this.webinarInfo = webinarInfo;
        if (roomInfo == null) {
            if (VssRoomManager.enter) {
                roomInfo = VssRoomManager.getInstance().getRoomInfo();
                if (mVhallPushLive != null) {
                    mVhallPushLive.setLogReportRoomId(roomInfo.getInav_id());
                }
                //添加消息监听
                VssRoomManager.getInstance().setVssMessageListener(new H5MessageChange(messageCallback, chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack() {
                    @Override
                    public void dataChange(WebinarInfo data) {
                        setWebinarInfo(data);
                    }

                    @Override
                    public void kickedOut() {

                    }
                }));
                VssRoomManager.getInstance().setVssCallBackListener(iVssCallBackListener);
            } else {
                if (listener != null) {
                    listener.onError(ERROR_NOT_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
                }
            }
        }
    }

    public BroadcastH5(Builder builder) {
        mVhallPushLive = new VHLivePusher(builder.videoCapture, builder.audioCapture, builder.config);
        this.streamOnly = builder.streamOnly;
        this.chatCallback = builder.chatCallback;
        this.messageCallback = builder.messageCallback;
        /**
         * 三方推流，不需要关心音视频处理，仅提供推流播放器初始化
         * 非三方推流
         */
        if (!streamOnly) {
            this.videoCapture = builder.videoCapture;
            this.mAudioCapture = builder.audioCapture;
            this.listener = builder.listener;
            mVhallPushLive.openNoiseCancelling(builder.denoise);
            mVhallPushLive.setListener(listener);
        }
    }

    /**
     * 销毁当前直播实例
     */
    @Override
    public void destroy() {
        if (mVhallPushLive != null && mVhallPushLive.getState() == Constants.State.START) {
            mVhallPushLive.release();
        }
        VssRoomManager.leaveRoom();
    }

    /**
     * 开始直播
     */
    @Override
    public void start(RequestCallback callback) {
        if (mVhallPushLive.getState() == Constants.State.START) {
            return;
        }
        if (roomInfo == null) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            return;
        }
        onStart(callback);

    }

    private void onStart(final RequestCallback callback) {
        if (mVhallPushLive == null) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            return;
        }

        VssRoomManager.getInstance().roomStartLive(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                mVhallPushLive.start(webinarInfo.vss_room_id, roomInfo.getPaas_access_token());
                if (callback != null)
                    callback.onSuccess();
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null)
                   callback.onError(eventCode,msg);
            }
        });
    }

    @Override
    public boolean pushStream(RequestCallback callback){
        mVhallPushLive.start(webinarInfo.vss_room_id, roomInfo.getPaas_access_token());
        if (callback != null)
            callback.onSuccess();
        return true;
    }

    /**
     * 停止直播
     */
    @Override
    public void stop() {
        if (mVhallPushLive == null) {
            return;
        }
        if (mVhallPushLive.getState() == Constants.State.START) {
            mVhallPushLive.stop();
        }
    }

    /**
     * @param content  发送内容
     * @param callback 发送回调
     */
    @Override
    public void sendChat(String content, final RequestCallback callback) {

        VssRoomManager.getInstance().sendMsg(content, "", new CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });

    }

    @Override
    public void sendCustom(JSONObject content, final RequestCallback callback) {
        VssRoomManager.getInstance().sendMsg(content.toString(), VHIM.TYPE_CUSTOM, new CallBack() {
                    @Override
                    public void onSuccess(Object result) {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        if (callback != null) {
                            callback.onError(eventCode, msg);
                        }
                    }
                }
        );
    }

    @Override
    public void connectChatServer() {
//paas层自动处理
    }

    @Override
    public void disconnectChatServer() {
//paas层自动处理
    }

    /**
     * @param show_all           false 显示当次直播聊天最多为20条,true显示所有聊天最条为200条，
     * @param chatRecordCallback 回调
     */
    @Override
    public void acquireChatRecord(boolean show_all, final ChatServer.ChatRecordCallback chatRecordCallback) {
        VssChatManager.getInstance().chatLists("1", show_all ? "200" : "20", "", new CallBack<List<ResponseChatInfo>>() {
            @Override
            public void onSuccess(List<ResponseChatInfo> result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryOld(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }

    /**
     * push音频数据
     *
     * @param data      音频数据（aac编码的数据）注意要先传音频头
     * @param size      音频数据大小
     * @param type      数据类型 0代表视频头 1代表音频头 2代表音频数据 3代表I帧 4代表p帧 5代表b帧
     * @param timestamp 音频时间戳 单位MS
     * @return 0是成功，非0是失败
     */
    @Override
    public int PushAACDataTs(byte[] data, int size, int type, long timestamp) {
        if (mVhallPushLive != null) {
            return mVhallPushLive.pushAACDataTs(data, size, type, timestamp);
        }
        return -1;
    }

    /**
     * push视频数据
     *
     * @param data      视屏数据(h264编码的数据) 注意要先传视频头
     * @param size      视频数据的大小
     * @param type      数据类型 0代表视频头 1代表音频头 2代表音频数据 3代表I帧 4代表p帧 5代表b帧
     * @param timestamp 视频时间戳 单位MS
     * @return 0是成功，非0是失败
     */
    @Override
    public int PushH264DataTs(byte[] data, int size, int type, long timestamp) {
        if (mVhallPushLive != null) {
            return mVhallPushLive.pushH264DataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int setVolumeAmplificateSize(float size) {
        if (mVhallPushLive != null) {
            return mVhallPushLive.setVolumeAmplificateSize(size);
        }
        return -1;
    }
}
