/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.message;

import com.vhall.vhallrtc.client.SignalingChannel;
import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.message.SignalingMessage;
import com.vhall.vhallrtc.message.SignalingMessageType;
import org.json.JSONException;
import org.json.JSONObject;
import org.vhwebrtc.SessionDescription;

public class SessionDescriptionMessage
extends SignalingMessage {
    private static final String kRTCSessionDescriptionTypeKey = "type";
    private static final String kRTCSessionDescriptionSdpKey = "sdp";
    private SessionDescription mSessionDescription = null;

    public SessionDescriptionMessage(SessionDescription session, String streamId, String peerSocketId) {
        super(SignalingMessageType.kVHSignalingMessageTypeOffer, streamId, peerSocketId);
        SignalingMessageType Type2 = SignalingMessageType.kVHSignalingMessageTypeOffer;
        if (session.type == SessionDescription.Type.OFFER) {
            Type2 = SignalingMessageType.kVHSignalingMessageTypeOffer;
        } else if (session.type == SessionDescription.Type.ANSWER) {
            Type2 = SignalingMessageType.kVHSignalingMessageTypeAnswer;
        }
        this.type = Type2;
        this.mSessionDescription = session;
    }

    public SessionDescription getSessionDescription() {
        return this.mSessionDescription;
    }

    @Override
    public JSONObject jsonObject() {
        JSONObject obj = null;
        try {
            obj = new JSONObject(this.mSessionDescription.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static class VHSessionDescription
    extends SessionDescription {
        public VHSessionDescription(SessionDescription.Type type, String description, int simulcastLayers) {
            super(type, SignalingChannel.EnableSimulcast(description, simulcastLayers));
        }

        public static SessionDescription descriptionFromJSONObject(JSONObject map) {
            String typeString = map.optString(SessionDescriptionMessage.kRTCSessionDescriptionTypeKey);
            String sdp = map.optString(SessionDescriptionMessage.kRTCSessionDescriptionSdpKey);
            SessionDescription.Type type = SessionDescription.Type.fromCanonicalForm((String)typeString);
            return new SessionDescription(type, sdp);
        }

        public String toString() {
            String type = this.type.canonicalForm();
            JSONObject obj = new JSONObject();
            try {
                obj.put(SessionDescriptionMessage.kRTCSessionDescriptionTypeKey, (Object)type);
                obj.put(SessionDescriptionMessage.kRTCSessionDescriptionSdpKey, (Object)this.description);
            }
            catch (JSONException e) {
                e.printStackTrace();
                LogManager.e("SessionDescription toString error.");
            }
            return obj.toString();
        }
    }
}

