/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.logreport;

import android.util.Base64;
import com.vhall.vhallrtc.client.Stream;
import com.vhall.vhallrtc.client.VHTool;
import com.vhall.vhallrtc.common.HttpRequest;
import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.common.Tool;
import com.vhall.vhallrtc.logreport.StreamLogReport;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class LogReport {
    private static final String mTag = "LogReport";
    private static LogReport mInstance = null;
    private long mLogId = 0L;
    public HashMap<String, StreamLogReport> mStreamLogReportDic = new HashMap();
    public static final String kHost = "host";
    public static final String kVer = "ver";
    public static final String kPublishTime = "release_date";
    public static final String kSession = "s";
    public static final String kBU = "bu";
    public static final String kDT = "dt";
    public static final String kOSV = "osv";
    public static final String kUA = "ua";
    public int bu = 0;
    public int pf = 5;
    public String reportUrl;
    public String reportMonitorUrl;
    public String sessionId;
    public String userid;
    public String aid;
    public String cid;
    public String localstreamid;
    public JSONObject logDataInfo = new JSONObject();

    public static String md5(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string.getBytes());
            String result = "";
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result = result + temp;
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private LogReport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogReport instance() {
        Class<LogReport> clazz = LogReport.class;
        synchronized (LogReport.class) {
            if (mInstance == null) {
                mInstance = new LogReport();
                String uuid = UUID.randomUUID().toString();
                LogReport.mInstance.sessionId = LogReport.md5(uuid + System.currentTimeMillis());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    long getLogId() {
        ++this.mLogId;
        return this.mLogId;
    }

    public boolean setLogRoominfo(String uid, String aid, String cid, int pf) {
        if (!uid.isEmpty()) {
            this.userid = uid;
        }
        if (!aid.isEmpty()) {
            this.aid = aid;
        }
        if (!cid.isEmpty()) {
            this.cid = cid;
        }
        if (pf >= 0) {
            this.pf = pf;
        }
        return true;
    }

    public void setLocalstreamid(String localstreamid) {
        this.localstreamid = localstreamid;
    }

    public boolean setLogDataInfo(JSONObject logInfo) {
        if (logInfo == null) {
            return false;
        }
        this.logDataInfo = logInfo;
        try {
            String systemModel;
            if (this.logDataInfo.has(kHost)) {
                this.reportUrl = this.logDataInfo.getString(kHost);
                try {
                    URL url = new URL(this.reportUrl);
                    this.reportMonitorUrl = url.getPort() > 0 ? url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + "/monitor" : url.getProtocol() + "://" + url.getHost() + "/monitor";
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                LogManager.i(mTag, "reportMonitorUrl:" + this.reportMonitorUrl);
                this.logDataInfo.remove(kHost);
            } else {
                LogManager.e(mTag, "data info is not contain host.");
            }
            if (this.logDataInfo.has(kBU)) {
                this.bu = this.logDataInfo.optInt(kBU);
            } else {
                LogManager.w(mTag, "bu field is empty.");
            }
            String systemVersion = VHTool.getSystemVersion();
            if (systemVersion != null) {
                this.logDataInfo.put(kOSV, (Object)("android " + systemVersion));
                this.logDataInfo.put(kUA, (Object)("android " + systemVersion));
            }
            if ((systemModel = VHTool.getSystemModel()) != null) {
                this.logDataInfo.put(kDT, (Object)systemModel);
            }
            this.logDataInfo.put(kVer, (Object)Tool.getSDKVersion());
            this.logDataInfo.put(kPublishTime, (Object)Tool.getPublishTime());
            this.logDataInfo.put(kSession, (Object)this.sessionId);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LogManager.e(mTag, "JSONException catch.");
        }
        return true;
    }

    public void reportLogWithKey(VhallLogReportKey key) {
        this.reportLogWithKeyAndStreamId(key, null, null);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId) {
        this.reportLogWithKeyAndStreamId(key, streamId, null);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId, String msg) {
        this.reportLogWithKeyAndStreamId(key, streamId, msg, -1);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId, String msg, int code) {
        this.reportLogWithKeyAndStreamId(key, streamId, msg, code, null);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId, String msg, int code, JSONObject info) {
        if (this.logDataInfo == null || this.reportUrl == null) {
            return;
        }
        JSONObject tmpObj = null;
        try {
            tmpObj = new JSONObject(this.logDataInfo.toString());
            tmpObj.put("uid", (Object)this.userid);
            tmpObj.put("aid", (Object)this.aid);
            tmpObj.put("cid", (Object)this.cid);
            tmpObj.put(kSession, (Object)this.sessionId);
            tmpObj.put("id", this.getLogId());
            tmpObj.put(kBU, this.bu);
            tmpObj.put("pf", this.pf);
            tmpObj.put("ld", System.currentTimeMillis());
            tmpObj.put(kVer, (Object)Tool.getSDKVersion());
            if (streamId != null) {
                tmpObj.put("p", (Object)streamId);
            }
            if (msg != null) {
                String _msg = msg;
                if (code != -1) {
                    _msg = _msg + ":" + code + "";
                }
                tmpObj.put("_m", (Object)_msg);
            } else {
                tmpObj.put("_m", (Object)"");
            }
            if (info != null) {
                Iterator it = info.keys();
                while (it.hasNext()) {
                    String item = (String)it.next();
                    tmpObj.put(item, info.get(item));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String token = tmpObj.toString();
        String host = null;
        host = key == VhallLogReportKey.kSignalingConnectSuccess || key == VhallLogReportKey.kSignalingDisconnect ? this.reportUrl : this.reportMonitorUrl;
        String url = null;
        try {
            url = host + "?k=" + key.getValue() + "&token=" + new String(Base64.encode((byte[])token.getBytes(), (int)2), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        LogManager.d(mTag, "report url:" + url + "token:" + token);
        HttpRequest.httpGetAsyncRequest(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamStart(LogReportDelegate delegate, Stream stream) {
        if (stream == null) {
            return;
        }
        StreamLogReport streamLogReport = null;
        LogReport logReport = this;
        synchronized (logReport) {
            if (this.mStreamLogReportDic.containsKey(stream.streamId)) {
                streamLogReport = this.mStreamLogReportDic.get(stream.streamId + "");
            } else {
                streamLogReport = new StreamLogReport();
                this.mStreamLogReportDic.put(stream.streamId + "", streamLogReport);
            }
        }
        streamLogReport.stream = stream;
        streamLogReport.streamStart(delegate, stream.streamId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamStop(String streamId) {
        if (streamId == null) {
            return;
        }
        LogReport logReport = this;
        synchronized (logReport) {
            if (this.mStreamLogReportDic.containsKey(streamId + "")) {
                StreamLogReport streamLogReport = this.mStreamLogReportDic.get(streamId + "");
                streamLogReport.streamStop();
                this.mStreamLogReportDic.remove(streamId + "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamError(String streamId) {
        if (streamId == null) {
            return;
        }
        LogReport logReport = this;
        synchronized (logReport) {
            if (this.mStreamLogReportDic.containsKey(streamId + "")) {
                StreamLogReport streamLogReport = this.mStreamLogReportDic.get(streamId + "");
                streamLogReport.streamError();
                this.mStreamLogReportDic.remove(streamId + "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamAllStop() {
        LogReport logReport = this;
        synchronized (logReport) {
            for (String key : this.mStreamLogReportDic.keySet()) {
                StreamLogReport streamLogReport = this.mStreamLogReportDic.get(key);
                if (streamLogReport == null) continue;
                streamLogReport.streamStop();
            }
            this.mStreamLogReportDic.clear();
        }
    }

    public static interface LogReportDelegate {
        public void onAudioLevel(String var1, int var2);
    }

    public static enum VhallLogType {
        kInfoLogType(5001),
        kLiveInfoLogType(5002);

        private int _value;

        private VhallLogType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VhallLogReportErrorCode {
        kNoneError(-1),
        kSubscribeError(4001),
        kSubscribeSuccess(2002),
        kPublishError(4002),
        kPublishSuccess(2003);

        private int _value;

        private VhallLogReportErrorCode(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VhallLogReportKey {
        kSignalingConnectSuccess(182001),
        kSignalingDisconnect(182002),
        kCallPublishMethod(182005),
        kSendPublishSignaling(182006),
        kSendPublishSignalingSuccess(182007),
        kLocalStreamCreatePeerconnection(182008),
        kLocalStreamSendOffer(182009),
        kLocalStreamRecvAndHandleAnswer(182010),
        kLocalStreamSendCandidate(182011),
        kLocalStreamRecvReadySignaling(182012),
        kCallSubscribeMethod(182013),
        kSendSubscribeSignaling(182014),
        kSendSubscribeSignalingSuccess(182015),
        kRemoteStreamCreatePeerconntion(182016),
        kRemoteStreamSendOffer(182017),
        kRemoteStreamRecvAndHandleAnswer(182018),
        kRemoteStreamSendCandidate(182019),
        kRemoteStreamRecvReadySignaling(182020),
        kNewStreamEnterRoom(182021),
        kSubscribeInfo(182003),
        kPublishInfo(182004),
        kCallUnpublishMethod(182022),
        kSendUnpublishSignaling(182023),
        kSendUnpublishSignalingSuccess(182024),
        kCallUnsubscribeMethod(182025),
        kSendUnsubscribeSignaling(182026),
        kCallSignalingDisconnectionMethod(182027),
        kRemoteStreamLeaveRoom(182028),
        kSendUnsubscribeSignalingSuccess(182029),
        kInitLocalStreamParam(182030),
        kMinitorPublishInfo(182100),
        kMinitorSubscribeInfo(182101),
        kConfigRoomBroadCast(182201),
        kConfigRoomBroadCastSuccess(182202),
        kRoomBroadCastMixOptionSuccess(182212),
        kMixLayoutModeBroadCast(182203),
        kMixLayoutModeBroadCastSuccess(182204),
        kMixLayoutMainScreenBroadCast(182205),
        kMixLayoutMainScreenBroadCastSuccess(182206),
        kStartRoomBroadCast(182207),
        kStartRoomBroadCastSuccess(182208),
        kStopRoomBroadCast(182209),
        kStopRoomBroadCastSuccess(182210),
        kStopRoomBroadCastMixoption(182210),
        kStopRoomBroadCastBackgroundImageSuccess(182215),
        kMixAdaptiveLayoutModeBroadCast(182213),
        kMixAdaptiveLayoutModeBroadCastFail(184207),
        kMixAdaptiveLayoutModeBroadCastSuccess(182214),
        kStartDocCloudRender(182033),
        kStopDocCloudRender(182034),
        kStartDocCloudResult(182035),
        kStopDocCloudResult(182036),
        kDocCloudEvent(182039),
        kInitLocalStream(182501),
        kInitLocalStreamFail(184501),
        kStartRender(182502),
        kStopRender(182503),
        kCallMuteAudioMethod(182504),
        kCallMuteVideoMethod(182505),
        kScreenShots(182506),
        kConfigVioceChange(182508),
        kReportVersionInfo(182601),
        kSignalingConnectFailure(184001),
        kCallPublishMethodFail(184002),
        kSendPublishSignalingFail(184003),
        kLocalStreamPeerconnectionDisconnected(184004),
        kRemoteUserQuitRoom(184005),
        kCallSubscribeMethodFail(184006),
        kSendSubscribeSignalingFail(184007),
        kRemoteStreamPeerconnectionDisconnected(184008),
        kCallUnpublishMethodFail(184009),
        kSendUnpublishSignalingFail(184010),
        kCallUnsubscribeMethodFail(184011),
        kSendUnsubcribeSignalingFail(184012),
        kSignalingServerDisconnected(184013),
        kConfigRoomBroadCastFail(184201),
        kMixLayoutModeBroadCastFail(184202),
        kMixLayoutMainScreenBroadCastFail(184203),
        kStartRoomBroadCastFail(184204),
        kStopRoomBroadCastFail(184205),
        kRoomBroadCastMixOptionFail(184206),
        kStopRoomBroadCastBackgroundImageFail(182215);

        private int _value;

        private VhallLogReportKey(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }
}

