/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.gpuimage;

import android.graphics.Bitmap;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class OpenGlUtils {
    public static final int NO_TEXTURE = -1;

    public static int loadTexture(Bitmap img, int usedTexId) {
        return OpenGlUtils.loadTexture(img, usedTexId, true);
    }

    public static int loadTexture(Bitmap img, int usedTexId, boolean recycle) {
        int[] textures = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            GLES20.glBindTexture((int)3553, (int)textures[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)img, (int)0);
        } else {
            GLES20.glBindTexture((int)3553, (int)usedTexId);
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)img);
            textures[0] = usedTexId;
        }
        if (recycle) {
            img.recycle();
        }
        return textures[0];
    }

    public static int loadTexture(ByteBuffer data, int width, int height, int usedTexId) {
        int[] textures = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            GLES20.glBindTexture((int)3553, (int)textures[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)data);
        } else {
            GLES20.glBindTexture((int)3553, (int)usedTexId);
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)data);
            textures[0] = usedTexId;
        }
        return textures[0];
    }

    public static int loadTexture(IntBuffer data, Camera.Size size, int usedTexId) {
        int[] textures = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            GLES20.glBindTexture((int)3553, (int)textures[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)size.width, (int)size.height, (int)0, (int)6408, (int)5121, (Buffer)data);
        } else {
            GLES20.glBindTexture((int)3553, (int)usedTexId);
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)size.width, (int)size.height, (int)6408, (int)5121, (Buffer)data);
            textures[0] = usedTexId;
        }
        return textures[0];
    }

    public static int loadTextureAsBitmap(IntBuffer data, Camera.Size size, int usedTexId) {
        Bitmap bitmap = Bitmap.createBitmap((int[])data.array(), (int)size.width, (int)size.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return OpenGlUtils.loadTexture(bitmap, usedTexId);
    }

    public static int loadShader(String strSource, int iType) {
        int[] compiled = new int[1];
        int iShader = GLES20.glCreateShader((int)iType);
        GLES20.glShaderSource((int)iShader, (String)strSource);
        GLES20.glCompileShader((int)iShader);
        GLES20.glGetShaderiv((int)iShader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.d((String)"Load Shader Failed", (String)("Compilation\n" + GLES20.glGetShaderInfoLog((int)iShader)));
            return 0;
        }
        return iShader;
    }

    public static int loadProgram(String strVSource, String strFSource) {
        int[] link = new int[1];
        int iVShader = OpenGlUtils.loadShader(strVSource, 35633);
        if (iVShader == 0) {
            Log.d((String)"Load Program", (String)"Vertex Shader Failed");
            return 0;
        }
        int iFShader = OpenGlUtils.loadShader(strFSource, 35632);
        if (iFShader == 0) {
            Log.d((String)"Load Program", (String)"Fragment Shader Failed");
            return 0;
        }
        int iProgId = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)iProgId, (int)iVShader);
        GLES20.glAttachShader((int)iProgId, (int)iFShader);
        GLES20.glLinkProgram((int)iProgId);
        GLES20.glGetProgramiv((int)iProgId, (int)35714, (int[])link, (int)0);
        if (link[0] <= 0) {
            Log.d((String)"Load Program", (String)"Linking Failed");
            return 0;
        }
        GLES20.glDeleteShader((int)iVShader);
        GLES20.glDeleteShader((int)iFShader);
        return iProgId;
    }

    public static float rnd(float min, float max) {
        float fRandNum = (float)Math.random();
        return min + (max - min) * fRandNum;
    }
}

