/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.gpuimage;

import android.annotation.SuppressLint;
import com.vhall.vhallrtc.gpuimage.GPUImageFilter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GPUImageSubareaFilter
extends GPUImageFilter {
    private float[] mRectArea;
    private FloatBuffer mAreaCubeBuffer;
    private FloatBuffer mAreaTextureBuffer;
    private GPUImageFilter mAreaFilter;

    public GPUImageSubareaFilter() {
        this(new float[]{0.0f, 0.0f, 1.0f, 1.0f});
    }

    public GPUImageSubareaFilter(float[] rectArea) {
        this.setRectArea(rectArea);
    }

    private void setRectAreaCoordBuffer(FloatBuffer srcCubeBuffer, FloatBuffer dstCubeBuffer, float[] rectArea) {
        float sx = srcCubeBuffer.get(0);
        float sy = srcCubeBuffer.get(1);
        float sw = srcCubeBuffer.get(2) - srcCubeBuffer.get(0);
        float sh = srcCubeBuffer.get(5) - srcCubeBuffer.get(1);
        float dx = rectArea[0] * sw + sx;
        float dy = rectArea[1] * sh + sy;
        float dw = rectArea[2] * sw;
        float dh = rectArea[3] * sh;
        dstCubeBuffer.put(0, dx);
        dstCubeBuffer.put(1, dy);
        dstCubeBuffer.put(2, dx + dw);
        dstCubeBuffer.put(3, dy);
        dstCubeBuffer.put(4, dx);
        dstCubeBuffer.put(5, dy + dh);
        dstCubeBuffer.put(6, dx + dw);
        dstCubeBuffer.put(7, dy + dh);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (this.mAreaFilter != null) {
            this.mAreaFilter.onOutputSizeChanged(width, height);
        }
    }

    @Override
    @SuppressLint(value={"WrongCall"})
    public void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        if (!this.isInitialized()) {
            return;
        }
        super.onDraw(textureId, cubeBuffer, textureBuffer);
        if (this.mRectArea != null) {
            this.setRectAreaCoordBuffer(cubeBuffer, this.mAreaCubeBuffer, this.mRectArea);
            this.setRectAreaCoordBuffer(textureBuffer, this.mAreaTextureBuffer, this.mRectArea);
        }
        this.mAreaCubeBuffer.position(0);
        this.mAreaTextureBuffer.position(0);
        if (this.mAreaFilter != null) {
            this.mAreaFilter.onDraw(textureId, this.mAreaCubeBuffer, this.mAreaTextureBuffer);
        } else {
            super.onDraw(textureId, this.mAreaCubeBuffer, this.mAreaTextureBuffer);
        }
    }

    public void setRectArea(float[] rectArea) {
        if (rectArea != null) {
            this.mRectArea = rectArea;
            this.mAreaCubeBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.mAreaTextureBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
    }

    public void setAreaCoordBuffer(FloatBuffer areaCubeBuffer, FloatBuffer areaTextureBuffer) {
        if (areaCubeBuffer != null && areaTextureBuffer != null) {
            this.mAreaCubeBuffer = areaCubeBuffer;
            this.mAreaTextureBuffer = areaTextureBuffer;
            this.mRectArea = null;
        }
    }

    public void setAreaFilter(GPUImageFilter areaFilter) {
        this.mAreaFilter = areaFilter;
    }
}

