/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.common;

import android.os.Build;
import android.util.Log;
import com.vhall.vhallrtc.common.LogManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tool {
    public static final String VIDEO_CODEC_VP8 = "VP8";
    public static final String VIDEO_CODEC_VP9 = "VP9";
    public static final String VIDEO_CODEC_H264 = "H264";
    public static final String VIDEO_CODEC_H264_BASELINE = "H264 Baseline";
    public static final String VIDEO_CODEC_H264_HIGH = "H264 High";
    private static final String PUBLISH_TIME = "20231009";
    public static final VhallStreamIdType mStreamIdType = VhallStreamIdType.VhallStreamIdTypeNumber;

    public static String getSDKVersion() {
        return "3.5.2";
    }

    public static void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    public static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    public static void logDeviceInfo(String tag) {
        Log.d((String)tag, (String)("Android SDK: " + Build.VERSION.SDK_INT + ", Release: " + Build.VERSION.RELEASE + ", Brand: " + Build.BRAND + ", Device: " + Build.DEVICE + ", Id: " + Build.ID + ", Hardware: " + Build.HARDWARE + ", Manufacturer: " + Build.MANUFACTURER + ", Model: " + Build.MODEL + ", Product: " + Build.PRODUCT));
    }

    public static String getPublishTime() {
        return PUBLISH_TIME;
    }

    public static String objectToString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue() + "";
        }
        return object.toString();
    }

    public static Object toTypeObject(Object obj) {
        switch (mStreamIdType) {
            case VhallStreamIdTypeNumber: {
                if (obj instanceof Number) {
                    return obj;
                }
                if (obj instanceof String) {
                    return Long.valueOf((String)obj);
                }
                return obj.toString();
            }
            case VhallStreamIdTypeString: {
                return Tool.objectToString(obj);
            }
        }
        return obj.toString();
    }

    public static String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        String[] lines = sdpDescription.split("\r\n");
        int mLineIndex = Tool.findMediaDescriptionLine(isAudio, lines);
        if (mLineIndex == -1) {
            LogManager.w("No mediaDescription line, so can't prefer " + codec);
            return sdpDescription;
        }
        ArrayList<String> codecPayloadTypes = new ArrayList<String>();
        Pattern codecPattern = Pattern.compile("^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$");
        for (int i = 0; i < lines.length; ++i) {
            Matcher codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecPayloadTypes.add(codecMatcher.group(1));
        }
        if (codecPayloadTypes.isEmpty()) {
            LogManager.w("No payload types with name " + codec);
            return sdpDescription;
        }
        String newMLine = Tool.movePayloadTypesToFront(codecPayloadTypes, lines[mLineIndex]);
        if (newMLine == null) {
            return sdpDescription;
        }
        LogManager.d("Change media description from: " + lines[mLineIndex] + " to " + newMLine);
        lines[mLineIndex] = newMLine;
        return Tool.joinString(Arrays.asList(lines), "\r\n", true);
    }

    private static int findMediaDescriptionLine(boolean isAudio, String[] sdpLines) {
        String mediaDescription = isAudio ? "m=audio " : "m=video ";
        for (int i = 0; i < sdpLines.length; ++i) {
            if (!sdpLines[i].startsWith(mediaDescription)) continue;
            return i;
        }
        return -1;
    }

    private static String joinString(Iterable<? extends CharSequence> s, String delimiter, boolean delimiterAtEnd) {
        Iterator<? extends CharSequence> iter = s.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        if (delimiterAtEnd) {
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static String movePayloadTypesToFront(List<String> preferredPayloadTypes, String mLine) {
        List<String> origLineParts = Arrays.asList(mLine.split(" "));
        if (origLineParts.size() <= 3) {
            LogManager.e("Wrong SDP media description format: " + mLine);
            return null;
        }
        List<String> header = origLineParts.subList(0, 3);
        ArrayList<String> unpreferredPayloadTypes = new ArrayList<String>(origLineParts.subList(3, origLineParts.size()));
        unpreferredPayloadTypes.removeAll(preferredPayloadTypes);
        ArrayList<String> newLineParts = new ArrayList<String>();
        newLineParts.addAll(header);
        newLineParts.addAll(preferredPayloadTypes);
        newLineParts.addAll(unpreferredPayloadTypes);
        return Tool.joinString(newLineParts, " ", false);
    }

    public static enum VhallStreamIdType {
        VhallStreamIdTypeNumber,
        VhallStreamIdTypeString;

    }
}

