/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.common;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.view.KeyEvent;
import com.vhall.vhallrtc.common.AppRTCAudioManager;
import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.common.Tool;
import java.util.List;
import java.util.Set;
import org.vhwebrtc.ThreadUtils;

public class AppRTCBluetoothManager {
    private static final String TAG = "AppRTCBluetoothManager";
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 4000;
    private static final int MAX_SCO_CONNECTION_ATTEMPTS = 3;
    private final Context apprtcContext;
    private final AppRTCAudioManager apprtcAudioManager;
    private final AudioManager audioManager;
    private final Handler handler;
    int scoConnectionAttempts;
    private State bluetoothState;
    private final BluetoothProfile.ServiceListener bluetoothServiceListener;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothHeadset bluetoothHeadset;
    private BluetoothDevice bluetoothDevice;
    private final BroadcastReceiver bluetoothHeadsetReceiver;
    private final Runnable bluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            AppRTCBluetoothManager.this.bluetoothTimeout();
        }
    };

    static AppRTCBluetoothManager create(Context context, AppRTCAudioManager audioManager) {
        LogManager.d(TAG, "create" + Tool.getThreadInfo());
        return new AppRTCBluetoothManager(context, audioManager);
    }

    protected AppRTCBluetoothManager(Context context, AppRTCAudioManager audioManager) {
        LogManager.d(TAG, "ctor");
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        this.apprtcAudioManager = audioManager;
        this.audioManager = this.getAudioManager(context);
        this.bluetoothState = State.UNINITIALIZED;
        this.bluetoothServiceListener = new BluetoothServiceListener();
        this.bluetoothHeadsetReceiver = new BluetoothHeadsetBroadcastReceiver();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public State getState() {
        ThreadUtils.checkIsOnMainThread();
        return this.bluetoothState;
    }

    public void start() {
        ThreadUtils.checkIsOnMainThread();
        LogManager.d(TAG, "start");
        if (!this.hasPermission(this.apprtcContext, "android.permission.BLUETOOTH")) {
            LogManager.w(TAG, "Process (pid=" + Process.myPid() + ") lacks BLUETOOTH permission");
            return;
        }
        if (this.bluetoothState != State.UNINITIALIZED) {
            LogManager.w(TAG, "Invalid BT state");
            return;
        }
        this.bluetoothHeadset = null;
        this.bluetoothDevice = null;
        this.scoConnectionAttempts = 0;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            LogManager.w(TAG, "Device does not support Bluetooth");
            return;
        }
        if (!this.audioManager.isBluetoothScoAvailableOffCall()) {
            LogManager.e(TAG, "Bluetooth SCO audio is not available off call");
            return;
        }
        this.logBluetoothAdapterInfo(this.bluetoothAdapter);
        if (!this.getBluetoothProfileProxy(this.apprtcContext, this.bluetoothServiceListener, 1)) {
            LogManager.e(TAG, "BluetoothAdapter.getProfileProxy(HEADSET) failed");
            return;
        }
        IntentFilter bluetoothHeadsetFilter = new IntentFilter();
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        bluetoothHeadsetFilter.addAction("android.intent.action.MEDIA_BUTTON");
        bluetoothHeadsetFilter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        this.registerReceiver(this.bluetoothHeadsetReceiver, bluetoothHeadsetFilter);
        LogManager.d(TAG, "HEADSET profile state: " + this.stateToString(this.bluetoothAdapter.getProfileConnectionState(1)));
        LogManager.d(TAG, "Bluetooth proxy for headset profile has started");
        this.bluetoothState = State.HEADSET_UNAVAILABLE;
        LogManager.d(TAG, "start done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    public void stop() {
        ThreadUtils.checkIsOnMainThread();
        LogManager.d(TAG, "stop: BT state=" + (Object)((Object)this.bluetoothState));
        if (this.bluetoothAdapter == null) {
            return;
        }
        this.stopScoAudio();
        if (this.bluetoothState == State.UNINITIALIZED) {
            return;
        }
        this.unregisterReceiver(this.bluetoothHeadsetReceiver);
        this.cancelTimer();
        if (this.bluetoothHeadset != null) {
            this.bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.bluetoothHeadset);
            this.bluetoothHeadset = null;
        }
        this.bluetoothAdapter = null;
        this.bluetoothDevice = null;
        this.bluetoothState = State.UNINITIALIZED;
        LogManager.d(TAG, "stop done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    public boolean startScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        LogManager.d(TAG, "startSco: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn());
        if (this.scoConnectionAttempts >= 3) {
            LogManager.e(TAG, "BT SCO connection fails - no more attempts");
            return false;
        }
        if (this.bluetoothState != State.HEADSET_AVAILABLE) {
            LogManager.e(TAG, "BT SCO connection fails - no headset available");
            return false;
        }
        LogManager.d(TAG, "Starting Bluetooth SCO and waits for ACTION_AUDIO_STATE_CHANGED...");
        this.bluetoothState = State.SCO_CONNECTING;
        this.audioManager.startBluetoothSco();
        this.audioManager.setBluetoothScoOn(true);
        ++this.scoConnectionAttempts;
        this.startTimer();
        LogManager.d(TAG, "startScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn());
        return true;
    }

    public void stopScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        LogManager.d(TAG, "stopScoAudio: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn());
        if (this.bluetoothState != State.SCO_CONNECTING && this.bluetoothState != State.SCO_CONNECTED) {
            return;
        }
        this.cancelTimer();
        this.audioManager.stopBluetoothSco();
        this.audioManager.setBluetoothScoOn(false);
        this.bluetoothState = State.SCO_DISCONNECTING;
        LogManager.d(TAG, "stopScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn());
    }

    public void updateDevice() {
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        LogManager.d(TAG, "updateDevice");
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.isEmpty()) {
            this.bluetoothDevice = null;
            this.bluetoothState = State.HEADSET_UNAVAILABLE;
            LogManager.d(TAG, "No connected bluetooth headset");
        } else {
            for (BluetoothDevice device : devices) {
                LogManager.i(device.getAddress());
                AppRTCAudioManager.HeadsetDevice headsetDevice = new AppRTCAudioManager.HeadsetDevice(AppRTCAudioManager.AudioDevice.BLUETOOTH, device.getAddress());
                AppRTCAudioManager.headsetConnected(headsetDevice);
            }
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            this.bluetoothState = State.HEADSET_AVAILABLE;
            LogManager.d(TAG, "Connected bluetooth headset: name=" + this.bluetoothDevice.getName() + ", state=" + this.stateToString(this.bluetoothHeadset.getConnectionState(this.bluetoothDevice)) + ", SCO audio=" + this.bluetoothHeadset.isAudioConnected(this.bluetoothDevice));
        }
        LogManager.d(TAG, "updateDevice done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    protected AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    protected void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    protected void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    protected boolean getBluetoothProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        return this.bluetoothAdapter.getProfileProxy(context, listener, profile);
    }

    protected boolean hasPermission(Context context, String permission2) {
        return this.apprtcContext.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @SuppressLint(value={"HardwareIds"})
    protected void logBluetoothAdapterInfo(BluetoothAdapter localAdapter) {
        LogManager.d(TAG, "BluetoothAdapter: enabled=" + localAdapter.isEnabled() + ", state=" + this.stateToString(localAdapter.getState()) + ", name=" + localAdapter.getName() + ", address=" + localAdapter.getAddress());
        Set pairedDevices = localAdapter.getBondedDevices();
        if (!pairedDevices.isEmpty()) {
            LogManager.d(TAG, "paired devices:");
            for (BluetoothDevice device : pairedDevices) {
                LogManager.d(TAG, " name=" + device.getName() + ", address=" + device.getAddress());
            }
        }
    }

    private void updateAudioDeviceState() {
        ThreadUtils.checkIsOnMainThread();
        LogManager.d(TAG, "updateAudioDeviceState");
        this.apprtcAudioManager.updateAudioDeviceState();
    }

    private void startTimer() {
        ThreadUtils.checkIsOnMainThread();
        LogManager.d(TAG, "startTimer");
        this.handler.postDelayed(this.bluetoothTimeoutRunnable, 4000L);
    }

    private void cancelTimer() {
        ThreadUtils.checkIsOnMainThread();
        LogManager.d(TAG, "cancelTimer");
        this.handler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    private void bluetoothTimeout() {
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        LogManager.d(TAG, "bluetoothTimeout: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn());
        if (this.bluetoothState != State.SCO_CONNECTING) {
            return;
        }
        boolean scoConnected = false;
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.size() > 0) {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            if (this.bluetoothHeadset.isAudioConnected(this.bluetoothDevice)) {
                LogManager.d(TAG, "SCO connected with " + this.bluetoothDevice.getName());
                scoConnected = true;
            } else {
                LogManager.d(TAG, "SCO is not connected with " + this.bluetoothDevice.getName());
            }
        }
        if (scoConnected) {
            this.bluetoothState = State.SCO_CONNECTED;
            this.scoConnectionAttempts = 0;
        } else {
            LogManager.w(TAG, "BT failed to connect after timeout");
            this.stopScoAudio();
        }
        this.updateAudioDeviceState();
        LogManager.d(TAG, "bluetoothTimeout done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    private boolean isScoOn() {
        return this.audioManager.isBluetoothScoOn();
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 2: {
                return "CONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 3: {
                return "DISCONNECTING";
            }
            case 10: {
                return "OFF";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
        }
        return "INVALID";
    }

    private String scoStateToString(int state) {
        switch (state) {
            case 1: {
                return "SCO_AUDIO_STATE_CONNECTED";
            }
            case 2: {
                return "SCO_AUDIO_STATE_CONNECTING";
            }
            case 0: {
                return "SCO_AUDIO_STATE_DISCONNECTED";
            }
            case -1: {
                return "SCO_AUDIO_STATE_ERROR";
            }
        }
        return "INVALID";
    }

    private class BluetoothHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private BluetoothHeadsetBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            String action = intent.getAction();
            if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                LogManager.d(AppRTCBluetoothManager.TAG, "BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_CONNECTION_STATE_CHANGED, s=" + AppRTCBluetoothManager.this.stateToString(state) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (state == 2) {
                    if (device != null) {
                        LogManager.i(device.getAddress());
                        AppRTCAudioManager.HeadsetDevice headsetDevice = new AppRTCAudioManager.HeadsetDevice(AppRTCAudioManager.AudioDevice.BLUETOOTH, device.getAddress());
                        AppRTCBluetoothManager.this.apprtcAudioManager;
                        AppRTCAudioManager.headsetConnected(headsetDevice);
                    }
                    AppRTCBluetoothManager.this.scoConnectionAttempts = 0;
                    AppRTCBluetoothManager.this.updateAudioDeviceState();
                } else if (state != 1 && state != 3 && state == 0) {
                    if (null != device) {
                        AppRTCBluetoothManager.this.apprtcAudioManager;
                        AppRTCAudioManager.headsetDisconnected(device.getAddress());
                        LogManager.i(device.getAddress());
                    }
                    AppRTCBluetoothManager.this.stopScoAudio();
                    AppRTCBluetoothManager.this.updateAudioDeviceState();
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                LogManager.d(AppRTCBluetoothManager.TAG, "BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_AUDIO_STATE_CHANGED, s=" + AppRTCBluetoothManager.this.stateToString(state) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
                if (state == 12) {
                    if (AppRTCBluetoothManager.this.bluetoothState == State.SCO_CONNECTING) {
                        LogManager.d(AppRTCBluetoothManager.TAG, "+++ Bluetooth audio SCO is now connected");
                    } else {
                        LogManager.w(AppRTCBluetoothManager.TAG, "Unexpected state BluetoothHeadset.STATE_AUDIO_CONNECTED");
                    }
                } else if (state == 11) {
                    LogManager.d(AppRTCBluetoothManager.TAG, "+++ Bluetooth audio SCO is now connecting...");
                } else if (state == 10) {
                    LogManager.d(AppRTCBluetoothManager.TAG, "+++ Bluetooth audio SCO is now disconnected");
                    if (this.isInitialStickyBroadcast()) {
                        LogManager.d(AppRTCBluetoothManager.TAG, "Ignore STATE_AUDIO_DISCONNECTED initial sticky broadcast.");
                        return;
                    }
                    AppRTCBluetoothManager.this.bluetoothState = State.SCO_DISCONNECTING;
                    AppRTCBluetoothManager.this.updateAudioDeviceState();
                }
            } else if ("android.intent.action.MEDIA_BUTTON".equals(action)) {
                KeyEvent event = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
                if (event != null) {
                    int keyCode = event.getKeyCode();
                    switch (keyCode) {
                        case 126: {
                            break;
                        }
                        case 127: {
                            break;
                        }
                        case 87: {
                            break;
                        }
                        case 88: {
                            break;
                        }
                    }
                }
            } else if (action.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                AppRTCBluetoothManager.this.audioManager;
                int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                LogManager.d(AppRTCBluetoothManager.TAG, "BT state " + AppRTCBluetoothManager.this.scoStateToString(state));
                if (AppRTCBluetoothManager.this.bluetoothState == State.SCO_CONNECTING) {
                    switch (state) {
                        case 1: {
                            AppRTCBluetoothManager.this.audioManager.setBluetoothScoOn(true);
                            AppRTCBluetoothManager.this.cancelTimer();
                            AppRTCBluetoothManager.this.bluetoothState = State.SCO_CONNECTED;
                            AppRTCBluetoothManager.this.scoConnectionAttempts = 0;
                            AppRTCBluetoothManager.this.updateAudioDeviceState();
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            AppRTCBluetoothManager.this.audioManager.startBluetoothSco();
                            if (AppRTCBluetoothManager.this.scoConnectionAttempts < 3) break;
                            AppRTCBluetoothManager.this.audioManager.setBluetoothScoOn(true);
                        }
                    }
                }
            }
            LogManager.d(AppRTCBluetoothManager.TAG, "onReceive done: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
        }
    }

    private class BluetoothServiceListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothServiceListener() {
        }

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile != 1 || AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            LogManager.d(AppRTCBluetoothManager.TAG, "BluetoothServiceListener.onServiceConnected: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
            AppRTCBluetoothManager.this.bluetoothHeadset = (BluetoothHeadset)proxy;
            AppRTCBluetoothManager.this.updateAudioDeviceState();
            LogManager.d(AppRTCBluetoothManager.TAG, "onServiceConnected done: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
        }

        public void onServiceDisconnected(int profile) {
            if (profile != 1 || AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            LogManager.d(AppRTCBluetoothManager.TAG, "BluetoothServiceListener.onServiceDisconnected: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
            AppRTCBluetoothManager.this.stopScoAudio();
            AppRTCBluetoothManager.this.bluetoothHeadset = null;
            AppRTCBluetoothManager.this.bluetoothDevice = null;
            AppRTCBluetoothManager.this.bluetoothState = State.HEADSET_UNAVAILABLE;
            AppRTCBluetoothManager.this.updateAudioDeviceState();
            LogManager.d(AppRTCBluetoothManager.TAG, "onServiceDisconnected done: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
        }
    }

    public static enum State {
        UNINITIALIZED,
        ERROR,
        HEADSET_UNAVAILABLE,
        HEADSET_AVAILABLE,
        SCO_DISCONNECTING,
        SCO_CONNECTING,
        SCO_CONNECTED;

    }
}

