/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import android.content.Context;
import com.vhall.vhallrtc.client.IFocusModeChangeListener;
import com.vhall.vhallrtc.client.VHBeautifyFilter;
import com.vhall.vhallrtc.client.VHCameraSession;
import org.vhwebrtc.Camera1Enumerator;
import org.vhwebrtc.CameraCapturer;
import org.vhwebrtc.CameraEnumerator;
import org.vhwebrtc.CameraSession;
import org.vhwebrtc.CameraVideoCapturer;
import org.vhwebrtc.Logging;
import org.vhwebrtc.SurfaceTextureHelper;

public class VHCameraCapturer
extends CameraCapturer {
    private final boolean captureToTexture;
    private boolean enableCaptureCallback = false;
    private VHBeautifyFilter.VideoCaptureCallback captureCallback = null;
    private VHCameraSession mCurrentCameraSession = null;

    public VHCameraCapturer(String cameraName, CameraVideoCapturer.CameraEventsHandler eventsHandler, boolean captureToTexture) {
        super(cameraName, eventsHandler, (CameraEnumerator)new Camera1Enumerator(captureToTexture));
        this.captureToTexture = captureToTexture;
    }

    public void createCameraSession(final CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, SurfaceTextureHelper surfaceTextureHelper, String s, int i, int i1, int i2) {
        VHCameraSession.create(new CameraSession.CreateSessionCallback(){

            public void onDone(CameraSession cameraSession) {
                if (cameraSession instanceof VHCameraSession) {
                    VHCameraCapturer.this.mCurrentCameraSession = (VHCameraSession)cameraSession;
                }
                if (null != createSessionCallback) {
                    createSessionCallback.onDone(cameraSession);
                }
            }

            public void onFailure(CameraSession.FailureType failureType, String s) {
                if (null != createSessionCallback) {
                    createSessionCallback.onFailure(failureType, s);
                }
            }
        }, events, this.captureToTexture, context, surfaceTextureHelper, null, Camera1Enumerator.getCameraIndex((String)s), i, i1, i2);
        VHCameraSession.setEnableCaptureCallback(this.enableCaptureCallback, this.captureCallback);
        Logging.d((String)"VHCameraCapturer--------", (String)("i:" + i + "i!" + i1));
    }

    public void stopCapture() {
        super.stopCapture();
        this.mCurrentCameraSession = null;
    }

    public void switchAutoFocusMode(boolean isAuto, IFocusModeChangeListener focusCallback) {
        if (null != this.mCurrentCameraSession) {
            this.mCurrentCameraSession.switchAutoFocusMode(isAuto, focusCallback);
        }
    }

    public void doOnAreaFocus(int x, int y, int surfaceWidth, int surfaceHeight) {
        if (null != this.mCurrentCameraSession) {
            this.mCurrentCameraSession.doOnAreaFocus(x, y, surfaceWidth, surfaceHeight);
        }
    }

    public void setEnableBeautify(boolean enable) {
        VHCameraSession.enableBeautify = enable;
    }

    public void setEnableCaptureCallback(boolean enable, VHBeautifyFilter.VideoCaptureCallback callback) {
        this.enableCaptureCallback = enable;
        this.captureCallback = callback;
        VHCameraSession.setEnableCaptureCallback(enable, callback);
    }

    public void setBeautifyLevel(int level) {
        VHCameraSession.setBeautifyLevel(level);
    }

    public void setMirror(boolean mirror) {
        if (null != this.mCurrentCameraSession) {
            this.mCurrentCameraSession.setMirror(mirror);
        }
    }
}

