/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.projection.MediaProjection;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.vhall.vhallrtc.client.Client;
import com.vhall.vhallrtc.client.FinishCallback;
import com.vhall.vhallrtc.client.IFocusModeChangeListener;
import com.vhall.vhallrtc.client.Room;
import com.vhall.vhallrtc.client.ScreenRecorder;
import com.vhall.vhallrtc.client.SignalingChannel;
import com.vhall.vhallrtc.client.VHBeautifyFilter;
import com.vhall.vhallrtc.client.VHCameraCapturer;
import com.vhall.vhallrtc.client.VHRenderView;
import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.logreport.LogReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.vhwebrtc.AudioSource;
import org.vhwebrtc.AudioTrack;
import org.vhwebrtc.Camera1Enumerator;
import org.vhwebrtc.CameraVideoCapturer;
import org.vhwebrtc.CapturerObserver;
import org.vhwebrtc.EglBase;
import org.vhwebrtc.MediaConstraints;
import org.vhwebrtc.MediaStream;
import org.vhwebrtc.MediaStreamTrack;
import org.vhwebrtc.PeerConnectionFactory;
import org.vhwebrtc.StatsObserver;
import org.vhwebrtc.StatsReport;
import org.vhwebrtc.SurfaceTextureHelper;
import org.vhwebrtc.VideoFrame;
import org.vhwebrtc.VideoSink;
import org.vhwebrtc.VideoSource;
import org.vhwebrtc.VideoTrack;

public class Stream {
    private static final String mTAG = "Stream";
    private static final String kDefualtFrameResolutionTable = "[{\"currentBitrateKbps\":200,\"maxBitrateKbps\":225,\"minBitrateKbps\":125,\"videoHeight\":144,\"videoWidth\":192},{\"currentBitrateKbps\":200,\"maxBitrateKbps\":250,\"minBitrateKbps\":150,\"videoHeight\":160,\"videoWidth\":240},{\"currentBitrateKbps\":230,\"maxBitrateKbps\":270,\"minBitrateKbps\":160,\"videoHeight\":240,\"videoWidth\":320},{\"currentBitrateKbps\":275,\"maxBitrateKbps\":350,\"minBitrateKbps\":170,\"videoHeight\":360,\"videoWidth\":480},{\"currentBitrateKbps\":400,\"maxBitrateKbps\":500,\"minBitrateKbps\":185,\"videoHeight\":432,\"videoWidth\":570},{\"currentBitrateKbps\":450,\"maxBitrateKbps\":550,\"minBitrateKbps\":200,\"videoHeight\":480,\"videoWidth\":640}]";
    public static final String kVHMediaStreamId = "LCMS";
    public static final String kVHAudioTrackId = "LCMSa0";
    public static final String kVHVideoTrackId = "LCMSv0";
    public static final String kVHVideoTrackKind = "video";
    public static final String kVideoWidthKey = "videoWidth";
    public static final String kVideoHeightKey = "videoHeight";
    public static final String kMinBitrateKbpsKey = "minBitrateKbps";
    public static final String kCurrentBitrateKey = "currentBitrateKbps";
    public static final String kMaxBitrateKey = "maxBitrateKbps";
    public static final String kFrameResolutionTypeKey = "frameResolutionType";
    public static final String kVideoFpsKey = "videoFps";
    public static final String kNumSpatialLayersKey = "numSpatialLayers";
    public static final String kVideoCodecPreferenceKey = "videoCodecPreference";
    public static final String kDualKey = "dual";
    public static final String kStreamOptionVideo = "video";
    public static final String kStreamOptionAudio = "audio";
    public static final String kStreamOptionData = "data";
    public static final String kStreamOptionMinVideoBW = "minVideoBW";
    public static final String kStreamOptionMaxVideoBW = "maxVideoBW";
    public static final String kStreamOptionStreamType = "streamType";
    public static final String kStreamOptionMuteStream = "muteStream";
    public static final String kStreamOptionMixAudio = "mixAudio";
    public static final String kStreamOptionMixVideo = "mixVideo";
    private static final String kRTCStatsTypeSSRC = "ssrc";
    private static final String kRTCStatsBytesSent = "bytesSent";
    private static final String kRTCStatsBytesReceived = "bytesReceived";
    private static final String kRTCStatsLastDate = "lastDate";
    private static final String kRTCStatsMediaTypeKey = "mediaType";
    private static final String kSimulcastKey = "simulcast";
    private static final int TimeInterval = 2000;
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_180 = 180;
    public static final int ROTATION_270 = 270;
    public static final int ROTATION_90 = 90;
    private SurfaceTextureHelper mSurfaceTextureHelper;
    private Context mApplicationContext;
    private EglBase mRootEglBase;
    private PeerConnectionFactory mPeerFactory = null;
    private StreamDelegate mStreamDelegate = null;
    public SignalingChannel signalingChannel = null;
    public MediaStream mediaStream = null;
    public Client client = null;
    public JSONObject streamOption;
    public JSONObject userDic;
    public MediaConstraints videoConstraints;
    public MediaConstraints audioConstraints;
    public String userId;
    public String streamId = "";
    public boolean isLocal = false;
    public boolean isPublish = false;
    public boolean isSubscribe = false;
    public boolean isOverseas = false;
    public JSONObject remoteMuteStream;
    public JSONObject muteStream;
    public String mStreamDate;
    private String mStreamAttributes;
    private String mUserAttributes;
    private VHCameraCapturer mVideoCapturerAndroid;
    private Timer mStatsTimer;
    private HashMap<String, HashMap<String, String>> mStatsBySSRC = new HashMap();
    private ArrayList<VHRenderView> mRenderViews = new ArrayList();
    private StatsCallback mStatsCallback;
    private TimerTask mTimerTask;
    private ScreenRecorder mScreenRecorder = null;
    public int mVideoHeight = 114;
    public int mVideoWidth = 176;
    public int mFps = 15;
    private int mSimulcastLayers = 1;
    private int mStreamType = 2;
    private int mMaxBitrateKbps = 200;
    private int mCurrentBitrateKbps = 180;
    private int mMinBitrateKbps = 100;
    private int mPublishProportionWidth = 0;
    private int mPublishProportionHeight = 0;
    public VideoFrame mLocalVideoFrame = null;
    private CaptureBufferCallback mCaptureBufferCallback = null;
    private boolean enableBeautify = false;
    private boolean enableCaptureCallback = false;

    public int getSimulcastLayers() {
        return this.mSimulcastLayers;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public int getMaxBitrateKbps() {
        return this.mMaxBitrateKbps;
    }

    public int getCurrentBitrateKbps() {
        return this.mCurrentBitrateKbps;
    }

    public int getMinBitrateKbps() {
        return this.mMinBitrateKbps;
    }

    public void setAttributes(@NonNull String attr) {
        this.mStreamAttributes = attr;
    }

    public String getAttributes() {
        return this.mStreamAttributes;
    }

    public String getUserAttributes() {
        return this.mUserAttributes;
    }

    public void setPublishProportion(Room.VHPublishProportion proportion) {
        if (proportion == Room.VHPublishProportion.PUBLIS_STREAM_ROW) {
            this.mPublishProportionWidth = 0;
            this.mPublishProportionHeight = 0;
        } else if (proportion == Room.VHPublishProportion.PUBLIS_STREAM_16_9) {
            this.mPublishProportionWidth = 16;
            this.mPublishProportionHeight = 9;
        } else {
            this.mPublishProportionWidth = 4;
            this.mPublishProportionHeight = 3;
        }
    }

    public void setUserAttributes(@NonNull String attri) {
        this.mUserAttributes = attri;
    }

    public void setCaptureBufferCallback(CaptureBufferCallback callback) {
        if (callback != null) {
            this.mCaptureBufferCallback = callback;
        }
    }

    public void setEnableCaptureCallback(boolean enable) {
        if (this.mVideoCapturerAndroid != null) {
            this.enableCaptureCallback = enable;
            this.mVideoCapturerAndroid.setEnableCaptureCallback(enable, new VHBeautifyFilter.VideoCaptureCallback(){

                @Override
                public int onVideoCaptureCallback(int w, int h, int tex) {
                    if (Stream.this.mCaptureBufferCallback != null) {
                        return Stream.this.mCaptureBufferCallback.onVideoCaptureTex(w, h, tex);
                    }
                    return tex;
                }
            });
        }
    }

    public void setEnableBeautify(boolean enable) {
        if (this.mVideoCapturerAndroid != null) {
            this.mVideoCapturerAndroid.setEnableBeautify(enable);
            this.enableBeautify = enable;
        }
    }

    public void switchAutoFocusMode(boolean isAuto, IFocusModeChangeListener focusCallback) {
        if (this.isLocal) {
            if (null != this.mVideoCapturerAndroid) {
                this.mVideoCapturerAndroid.switchAutoFocusMode(isAuto, (result, msg) -> {
                    if (null != this.mRenderViews && result) {
                        for (VHRenderView renderView : this.mRenderViews) {
                            renderView.changeAutoFocusEnable(isAuto);
                        }
                    }
                    if (null != focusCallback) {
                        focusCallback.onComplete(result, msg);
                    }
                });
            }
        } else {
            Log.e((String)mTAG, (String)"only LocalStream supports focus-mode");
        }
    }

    void doOnAreaFocus(int x, int y, int surfaceWidth, int surfaceHeight) {
        if (null != this.mVideoCapturerAndroid) {
            this.mVideoCapturerAndroid.doOnAreaFocus(x, y, surfaceWidth, surfaceHeight);
        }
    }

    public void setStreamDelegate(StreamDelegate delegate) {
        this.mStreamDelegate = delegate;
    }

    public void setBeautifyLevel(int level) {
        if (this.mVideoCapturerAndroid != null) {
            this.mVideoCapturerAndroid.setBeautifyLevel(level);
        }
    }

    public Stream(@NonNull String streamId, @NonNull JSONObject streamData, @NonNull SignalingChannel channel, int streamType) {
        this(streamId, streamData, channel);
        this.mStreamType = streamType;
    }

    public Stream(@NonNull String streamId, @NonNull JSONObject streamData, @NonNull SignalingChannel channel) {
        this(0, null);
        this.streamId = streamId;
        this.signalingChannel = channel;
        this.isLocal = false;
        this.mStreamDate = streamData.toString();
        try {
            JSONObject numSpatialLayers;
            if (streamData.has(kStreamOptionMuteStream)) {
                this.remoteMuteStream = streamData.getJSONObject(kStreamOptionMuteStream);
            }
            this.streamOption.put(kDualKey, 0);
            if (streamData.has("user")) {
                this.userDic = new JSONObject(streamData.optJSONObject("user").toString());
            }
            if (streamData.has(kStreamOptionStreamType)) {
                this.mStreamType = streamData.optInt(kStreamOptionStreamType);
            }
            if (streamData.has("type") && "doc-cloud-render".equals(streamData.get("type"))) {
                this.mStreamType = 100;
                this.streamOption.put("video", false);
                this.streamOption.put(kStreamOptionAudio, false);
                this.mFps = 5;
            }
            if (this.userDic != null) {
                if (this.userDic.has("id")) {
                    this.userId = this.userDic.optString("id");
                }
                if (this.userDic.has("attributes")) {
                    this.mUserAttributes = this.userDic.optString("attributes");
                }
            }
            if (streamData.has("attributes")) {
                this.mStreamAttributes = streamData.optString("attributes");
            }
            if (streamData.optJSONObject(kSimulcastKey) != null && streamData.optJSONObject(kSimulcastKey) instanceof JSONObject && (numSpatialLayers = streamData.optJSONObject(kSimulcastKey)).has(kNumSpatialLayersKey)) {
                this.mSimulcastLayers = numSpatialLayers.optInt(kNumSpatialLayersKey);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public Stream(@NonNull Context context, @NonNull EglBase eglBase, @NonNull PeerConnectionFactory factory, @Nullable JSONObject option, @Nullable String attributes) {
        this(0, null, context, eglBase, factory, option, attributes, null, null);
    }

    public Stream(@NonNull int dpi, @NonNull MediaProjection mp, @NonNull Context context, @NonNull EglBase eglBase, @NonNull PeerConnectionFactory factory, @Nullable JSONObject option, @Nullable String attributes) {
        this(dpi, mp, context, eglBase, factory, option, attributes, null, null);
    }

    private Stream(@Nullable int dpi, @Nullable MediaProjection mp) {
        if (mp != null) {
            this.mStreamType = VhallStreamType.VhallStreamTypeScreen.getValue();
            this.mScreenRecorder = new ScreenRecorder(dpi, mp);
        }
        this.muteStream = new JSONObject();
        this.streamOption = new JSONObject();
        this.mStreamAttributes = null;
        try {
            this.muteStream.put("video", false);
            this.muteStream.put(kStreamOptionAudio, false);
            this.streamOption.put("video", true);
            this.streamOption.put(kStreamOptionAudio, true);
            this.streamOption.put(kStreamOptionData, true);
            this.streamOption.put(kStreamOptionMuteStream, (Object)this.muteStream);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LogManager.e(mTAG, "localMuteStream json object error.");
        }
    }

    private Stream(@Nullable int dpi, @Nullable MediaProjection mp, @NonNull Context context, @NonNull EglBase eglBase, @NonNull PeerConnectionFactory factory, @Nullable JSONObject option, @Nullable String attributes, @Nullable MediaConstraints videoConstraints, @Nullable MediaConstraints audioConstraints) {
        this(dpi, mp);
        this.mApplicationContext = context;
        this.mRootEglBase = eglBase;
        this.mPeerFactory = factory;
        try {
            this.streamOption.put(kStreamOptionStreamType, this.mStreamType);
            this.streamOption.put(kStreamOptionMinVideoBW, 0);
            this.streamOption.put(kVideoCodecPreferenceKey, (Object)"VP8");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (option != null) {
            if (option.has(kFrameResolutionTypeKey)) {
                try {
                    int key = option.getInt(kFrameResolutionTypeKey);
                    JSONArray list = new JSONArray(kDefualtFrameResolutionTable);
                    JSONObject resolutionObj = list.getJSONObject(key);
                    if (resolutionObj != null) {
                        if (resolutionObj.has(kVideoWidthKey)) {
                            this.mVideoWidth = resolutionObj.optInt(kVideoWidthKey);
                        }
                        if (resolutionObj.has(kVideoHeightKey)) {
                            this.mVideoHeight = resolutionObj.optInt(kVideoHeightKey);
                        }
                        if (resolutionObj.has(kMaxBitrateKey)) {
                            this.mMaxBitrateKbps = resolutionObj.optInt(kMaxBitrateKey);
                        }
                        if (resolutionObj.has(kCurrentBitrateKey)) {
                            this.mCurrentBitrateKbps = resolutionObj.optInt(kCurrentBitrateKey);
                        }
                        if (resolutionObj.has(kMinBitrateKbpsKey)) {
                            this.mMinBitrateKbps = resolutionObj.optInt(kMinBitrateKbpsKey);
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                option.remove(kFrameResolutionTypeKey);
            }
            if (option.has(kVideoWidthKey)) {
                this.mVideoWidth = option.optInt(kVideoWidthKey);
                option.remove(kVideoWidthKey);
            }
            if (option.has(kVideoHeightKey)) {
                this.mVideoHeight = option.optInt(kVideoHeightKey);
                option.remove(kVideoHeightKey);
            }
            if (option.has(kMaxBitrateKey)) {
                this.mMaxBitrateKbps = option.optInt(kMaxBitrateKey);
                option.remove(kMaxBitrateKey);
            }
            if (option.has(kCurrentBitrateKey)) {
                this.mCurrentBitrateKbps = option.optInt(kCurrentBitrateKey);
                option.remove(kCurrentBitrateKey);
            }
            if (option.has(kMinBitrateKbpsKey)) {
                this.mMinBitrateKbps = option.optInt(kMinBitrateKbpsKey);
                option.remove(kMinBitrateKbpsKey);
            }
            if (option.has(kVideoFpsKey)) {
                this.mFps = option.optInt(kVideoFpsKey);
                option.remove(kVideoFpsKey);
            }
            if (option.has(kNumSpatialLayersKey)) {
                this.mSimulcastLayers = option.optInt(kNumSpatialLayersKey);
                option.remove(kNumSpatialLayersKey);
                if (this.mSimulcastLayers > 1) {
                    JSONObject simulcast = new JSONObject();
                    try {
                        simulcast.put(kNumSpatialLayersKey, this.mSimulcastLayers);
                        this.streamOption.put(kSimulcastKey, (Object)simulcast);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (option.has(kStreamOptionStreamType)) {
                try {
                    int streamType = option.optInt(kStreamOptionStreamType);
                    if (streamType == VhallStreamType.VhallStreamTypeOnlyAudio.getValue()) {
                        this.streamOption.put("video", false);
                    } else if (streamType == VhallStreamType.VhallStreamTypeOnlyVideo.getValue()) {
                        this.streamOption.put(kStreamOptionAudio, false);
                    } else {
                        this.streamOption.put("video", true);
                        this.streamOption.put(kStreamOptionAudio, true);
                    }
                    this.mStreamType = streamType;
                    this.streamOption.put(kStreamOptionStreamType, this.mStreamType);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (option.has(kStreamOptionMixAudio) && option.has(kStreamOptionMixVideo)) {
                JSONObject mixobj = new JSONObject();
                try {
                    mixobj.put(kStreamOptionMixAudio, option.optBoolean(kStreamOptionMixAudio));
                    mixobj.put(kStreamOptionMixVideo, option.optBoolean(kStreamOptionMixVideo));
                    this.streamOption.put("mixOption", (Object)mixobj);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    LogManager.e(mTAG, "localMuteStream json object error.");
                }
            }
            try {
                Iterator iterator = option.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    this.streamOption.putOpt(key, option.opt(key));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (this.streamOption.has(kVideoCodecPreferenceKey) && !this.streamOption.optString(kVideoCodecPreferenceKey).equals("VP8")) {
                this.streamOption.remove(kSimulcastKey);
            }
            LogManager.i(mTAG, "option: " + this.streamOption.toString() + " width: " + this.mVideoWidth + " height: " + this.mVideoHeight + " kMaxBitrateKey: " + this.mMaxBitrateKbps + " kCurrentBitrateKey: " + this.mCurrentBitrateKbps + " kMinBitrateKbpsKey: " + this.mMinBitrateKbps);
        }
        if (attributes != null) {
            this.mStreamAttributes = attributes;
        }
        this.videoConstraints = videoConstraints == null ? new MediaConstraints() : videoConstraints;
        this.audioConstraints = audioConstraints == null ? new MediaConstraints() : audioConstraints;
        this.isLocal = true;
        if (this.createLocalStream() != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kInitLocalStream, this.streamId, option.toString());
        } else {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kInitLocalStreamFail, this.streamId, option.toString());
        }
    }

    public boolean hasAudio() {
        return this.mediaStream != null && this.mediaStream.audioTracks.size() > 0;
    }

    public boolean hasVideo() {
        return this.mediaStream != null && this.mediaStream.videoTracks.size() > 0;
    }

    public boolean hasData() {
        return this.streamOption.optBoolean(kStreamOptionData);
    }

    public boolean muteAudio(@Nullable FinishCallback callback) {
        for (AudioTrack audioTrack : this.mediaStream.audioTracks) {
            audioTrack.setEnabled(false);
        }
        try {
            this.muteStream.put(kStreamOptionAudio, true);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        this.sendMuteStreamMsg(this.muteStream, callback);
        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallMuteAudioMethod, this.streamId, "set audio mute: true");
        return true;
    }

    public boolean unmuteAudio(@Nullable FinishCallback callback) {
        for (AudioTrack audioTrack : this.mediaStream.audioTracks) {
            audioTrack.setEnabled(true);
        }
        try {
            this.muteStream.put(kStreamOptionAudio, false);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        this.sendMuteStreamMsg(this.muteStream, callback);
        return true;
    }

    public boolean muteVideo(@Nullable FinishCallback callback) {
        for (VideoTrack videoTrack : this.mediaStream.videoTracks) {
            videoTrack.setEnabled(false);
        }
        try {
            this.muteStream.put("video", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        this.sendMuteStreamMsg(this.muteStream, callback);
        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallMuteVideoMethod, this.streamId, "set video mute: true");
        return true;
    }

    public boolean unmuteVideo(@Nullable FinishCallback callback) {
        for (VideoTrack videoTrack : this.mediaStream.videoTracks) {
            videoTrack.setEnabled(true);
        }
        try {
            this.muteStream.put("video", false);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        this.sendMuteStreamMsg(this.muteStream, callback);
        return true;
    }

    public boolean switchCamera() {
        if (this.mVideoCapturerAndroid != null) {
            this.mVideoCapturerAndroid.switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                public void onCameraSwitchDone(boolean b) {
                    if (Stream.this.mCaptureBufferCallback != null) {
                        Stream.this.mCaptureBufferCallback.onCameraSwitch(b);
                    }
                    LogManager.d(Stream.mTAG, "onCameraSwitchDone: " + b);
                    Stream.this.setEnableBeautify(Stream.this.enableBeautify);
                    Stream.this.setEnableCaptureCallback(Stream.this.enableCaptureCallback);
                }

                public void onCameraSwitchError(String s) {
                    LogManager.e(Stream.mTAG, "onCameraSwitchError: " + s);
                }
            });
        }
        return true;
    }

    public void setMirror(boolean mirror) {
        if (this.mVideoCapturerAndroid != null) {
            this.mVideoCapturerAndroid.setMirror(mirror);
        }
    }

    public void switchDualStream(@NonNull int type, @Nullable FinishCallback finish) {
        if (this.signalingChannel != null && !this.isLocal) {
            this.signalingChannel.switchDualStream(this.streamId, type, finish);
        }
    }

    public void setMixLayoutMainScreen(String mode, final @Nullable FinishCallback finish) {
        if (this.signalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixLayoutMainScreenBroadCast, this.streamId, "Call setMixLayoutMainScreen api" + mode);
            this.signalingChannel.setMixLayoutMainScreen(this.streamId, mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixLayoutMainScreenBroadCastSuccess, null, " setMixLayoutMainScreen success");
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixLayoutMainScreenBroadCastFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public synchronized void addRenderView(VHRenderView renderView) {
        if (this.mRenderViews != null) {
            this.mRenderViews.add(renderView);
        }
        if (this.mediaStream != null) {
            for (VideoTrack videoTrack : this.mediaStream.videoTracks) {
                videoTrack.addSink((VideoSink)renderView);
            }
            renderView.stream = this;
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStartRender, this.streamId);
        }
    }

    public synchronized void removeRenderView(VHRenderView renderView) {
        if (this.mRenderViews != null && this.mRenderViews.contains((Object)renderView)) {
            this.mRenderViews.remove((Object)renderView);
            if (this.mediaStream != null) {
                for (VideoTrack videoTrack : this.mediaStream.videoTracks) {
                    renderView.clearImage();
                    videoTrack.removeSink((VideoSink)renderView);
                }
                renderView.stream = null;
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRender, this.streamId);
            }
        }
    }

    public synchronized void removeAllRenderView() {
        if (this.mRenderViews != null && this.mRenderViews.size() > 0) {
            for (VHRenderView renderView : this.mRenderViews) {
                for (VideoTrack videoTrack : this.mediaStream.videoTracks) {
                    renderView.clearImage();
                    videoTrack.removeSink((VideoSink)renderView);
                }
                renderView.stream = null;
            }
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRender, this.streamId);
            this.mRenderViews.clear();
        }
    }

    public synchronized ArrayList<VHRenderView> getRenderViews() {
        return this.mRenderViews;
    }

    public void setVolume(double volume) {
        if (this.mediaStream != null) {
            for (AudioTrack audioTrack : this.mediaStream.audioTracks) {
                audioTrack.setVolume(volume);
            }
        }
    }

    public void changeVoiceType(int newType) {
        if (this.mPeerFactory != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kConfigVioceChange, this.streamId);
        }
    }

    public int getVoiceChangeType() {
        if (this.mPeerFactory != null) {
            // empty if block
        }
        return 0;
    }

    public void setPitchChange(double value) {
        if (this.mPeerFactory != null) {
            // empty if block
        }
    }

    public void startStats(@NonNull StatsCallback callback) {
        this.mStatsCallback = callback;
        if (this.mStatsTimer == null) {
            this.mStatsTimer = new Timer();
            this.mTimerTask = new TimerTask(){

                @Override
                public void run() {
                    Stream.this.gatherTrackStats();
                }
            };
            this.mStatsTimer.schedule(this.mTimerTask, 0L, 2000L);
        }
    }

    public void stopStats() {
        if (this.mStatsTimer != null) {
            this.mStatsTimer.cancel();
            this.mStatsTimer = null;
        }
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
    }

    @TargetApi(value=21)
    public void dispose() {
        if (this.mVideoCapturerAndroid != null) {
            this.mVideoCapturerAndroid.stopCapture();
            this.mVideoCapturerAndroid.dispose();
            this.mVideoCapturerAndroid = null;
        }
        if (this.mScreenRecorder != null) {
            this.mScreenRecorder.stopCapture();
            this.mScreenRecorder.dispose();
            this.mScreenRecorder = null;
        }
        this.removeAudioTracks();
        this.removeVideoTracks();
        if (this.mediaStream != null) {
            // empty if block
        }
        if (this.mSurfaceTextureHelper != null) {
            this.mSurfaceTextureHelper.dispose();
            this.mSurfaceTextureHelper = null;
        }
    }

    public void getSsrcStats(@NonNull StatsCallback callback) {
        this.mStatsCallback = callback;
        this.gatherTrackStats();
    }

    public void getRTCAudioInfo(final @NonNull StatsReportCallback callback) {
        LinkedList<AudioTrack> tracks = new LinkedList<AudioTrack>();
        List audioTracks = this.mediaStream.audioTracks;
        for (AudioTrack track : audioTracks) {
            tracks.add(track);
        }
        for (AudioTrack track : tracks) {
            if (this.client == null) {
                return;
            }
            boolean ret = this.client.getStats(new StatsObserver(){

                public void onComplete(StatsReport[] statsReports) {
                    int size = statsReports.length;
                    for (StatsReport stat : statsReports) {
                        if (!stat.type.equals(Stream.kRTCStatsTypeSSRC)) continue;
                        HashMap<String, String> statMap = new HashMap<String, String>();
                        for (StatsReport.Value value : stat.values) {
                            statMap.put(value.name, value.value);
                        }
                        if (callback == null) continue;
                        callback.onResponse(0, 0, statMap);
                    }
                }
            }, (MediaStreamTrack)track);
            if (ret) continue;
            LogManager.e(mTAG, "peerConnection.getStats error.");
        }
    }

    public void getRTCLegacyStatsReport(final @NonNull StatsReportCallback callback) {
        if (this.mediaStream == null) {
            return;
        }
        final LinkedList<Object> tracks = new LinkedList<Object>();
        List videoTracks = this.mediaStream.videoTracks;
        for (Object track : videoTracks) {
            tracks.add(track);
        }
        List audioTracks = this.mediaStream.audioTracks;
        for (AudioTrack track : audioTracks) {
            tracks.add(track);
        }
        final int trackCount = tracks.size();
        for (final MediaStreamTrack mediaStreamTrack : tracks) {
            if (this.client == null) {
                return;
            }
            boolean ret = this.client.getStats(new StatsObserver(){

                public void onComplete(StatsReport[] statsReports) {
                    int size = statsReports.length;
                    for (StatsReport stat : statsReports) {
                        if (!stat.type.equals(Stream.kRTCStatsTypeSSRC)) continue;
                        HashMap<String, String> statMap = new HashMap<String, String>();
                        for (StatsReport.Value value : stat.values) {
                            statMap.put(value.name, value.value);
                        }
                        if (callback == null) continue;
                        callback.onResponse(trackCount, tracks.indexOf(mediaStreamTrack), statMap);
                    }
                }
            }, mediaStreamTrack);
            if (ret) continue;
            LogManager.e(mTAG, "peerConnection.getStats error.");
        }
    }

    public String toString() {
        JSONObject option = null;
        try {
            option = new JSONObject(this.streamOption.toString());
            option.put(kMinBitrateKbpsKey, this.mMinBitrateKbps);
            option.put(kCurrentBitrateKey, this.mCurrentBitrateKbps);
            option.put(kMaxBitrateKey, this.mMaxBitrateKbps);
            option.put(kVideoWidthKey, this.mVideoWidth);
            option.put(kVideoHeightKey, this.mVideoHeight);
            option.put(kVideoFpsKey, this.mFps);
            option.put(kNumSpatialLayersKey, this.mSimulcastLayers);
        }
        catch (JSONException e) {
            e.printStackTrace();
            option = new JSONObject();
        }
        return option.toString();
    }

    private void gatherTrackStats() {
        this.getRTCLegacyStatsReport(new StatsReportCallback(){

            @Override
            public void onResponse(int trackCount, int trackIndex, Map<String, String> statMap) {
                Stream.this.processRTCLegacyStatsReport(statMap);
                String kRTCStatsBytes = Stream.this.isLocal ? Stream.kRTCStatsBytesSent : Stream.kRTCStatsBytesReceived;
                HashMap<String, String> bytesMap = new HashMap<String, String>();
                bytesMap.put(kRTCStatsBytes, statMap.get(kRTCStatsBytes));
                bytesMap.put(Stream.kRTCStatsLastDate, "" + System.currentTimeMillis());
                Stream.this.mStatsBySSRC.put(statMap.get(Stream.kRTCStatsTypeSSRC), bytesMap);
            }
        });
    }

    private void processRTCLegacyStatsReport(Map<String, String> stat) {
        String mediaType = stat.get(kRTCStatsMediaTypeKey);
        long kbps = this.calculateBitrateForStatsReport(stat);
        if (this.mStatsCallback != null) {
            this.mStatsCallback.onResponse(mediaType, kbps, stat);
        }
    }

    private long calculateBitrateForStatsReport(Map<String, String> statsReport) {
        String kRTCStatsBytes = this.isLocal ? kRTCStatsBytesSent : kRTCStatsBytesReceived;
        String ssrc = statsReport.get(kRTCStatsTypeSSRC);
        long bytes = Integer.valueOf(statsReport.get(kRTCStatsBytes)).longValue();
        if (this.mStatsBySSRC.containsKey(ssrc)) {
            Map ssrcMap = this.mStatsBySSRC.get(ssrc);
            if (!ssrcMap.containsKey(kRTCStatsBytes)) {
                return 0L;
            }
            long lastBytes = Long.valueOf((String)ssrcMap.get(kRTCStatsBytes));
            if (!ssrcMap.containsKey(kRTCStatsLastDate)) {
                return 0L;
            }
            long lastStatsTS = Long.valueOf((String)ssrcMap.get(kRTCStatsLastDate));
            double seconds = (double)(System.currentTimeMillis() - lastStatsTS) / 1000.0;
            long kbps = (long)((double)((bytes - lastBytes) * 8L) / Math.abs(seconds) / 1000.0);
            return kbps;
        }
        return 0L;
    }

    public void ChangeCarameFormat(int width, int height, int fps) {
        if (this.mVideoCapturerAndroid != null) {
            this.mVideoCapturerAndroid.changeCaptureFormat(width, height, fps);
        }
    }

    private MediaStream createLocalStream() {
        this.mediaStream = this.mPeerFactory.createLocalMediaStream(kVHMediaStreamId);
        if (this.streamOption.optBoolean("video")) {
            this.generateVideoTracks();
        }
        if (this.streamOption.optBoolean(kStreamOptionAudio)) {
            this.generateAudioTracks();
        }
        return this.mediaStream;
    }

    private int MEMALIGN(int x, int a) {
        return x & ~(a - 1);
    }

    private VideoTrack createLocalVideoTrack() {
        VideoSource videoSource;
        VideoTrack videoTrack = null;
        this.mSurfaceTextureHelper = SurfaceTextureHelper.create((String)"CaptureThread", (EglBase.Context)this.mRootEglBase.getEglBaseContext());
        if (this.mStreamType == VhallStreamType.VhallStreamTypeOnlyAudio.getValue()) {
            return videoTrack;
        }
        if (this.mStreamType == VhallStreamType.VhallStreamTypeScreen.getValue()) {
            videoSource = this.mPeerFactory.createVideoSource(true);
            this.mScreenRecorder.initialize(this.mSurfaceTextureHelper, this.mApplicationContext, new CapturerObserver(){

                public void onCapturerStarted(boolean b) {
                    videoSource.getCapturerObserver().onCapturerStarted(b);
                }

                public void onCapturerStopped() {
                    videoSource.getCapturerObserver().onCapturerStopped();
                }

                public void onFrameCaptured(VideoFrame videoFrame) {
                    Stream.this.mLocalVideoFrame = videoFrame;
                    videoSource.getCapturerObserver().onFrameCaptured(videoFrame);
                }
            });
            this.mScreenRecorder.startCapture(this.mVideoWidth, this.mVideoHeight, this.mFps);
        } else {
            Camera1Enumerator enumerator = new Camera1Enumerator(false);
            String[] names = enumerator.getDeviceNames();
            String name = names[0];
            for (String item : names) {
                if (!enumerator.isFrontFacing(item)) continue;
                name = item;
                break;
            }
            this.mVideoCapturerAndroid = new VHCameraCapturer(name, new CameraVideoCapturer.CameraEventsHandler(){

                public void onCameraError(String s) {
                    if (Stream.this.mStreamDelegate != null) {
                        Stream.this.mStreamDelegate.onError(VhallStreamEventType.VhallStreamEventTypeCameraError, s);
                    }
                    if (Stream.this.mCaptureBufferCallback != null) {
                        Stream.this.mCaptureBufferCallback.onCameraError(s);
                    }
                }

                public void onCameraDisconnected() {
                    if (Stream.this.mStreamDelegate != null) {
                        Stream.this.mStreamDelegate.onEvent(VhallStreamEventType.CameraDisconnected, "onCameraDisconnected");
                    }
                    if (Stream.this.mCaptureBufferCallback != null) {
                        Stream.this.mCaptureBufferCallback.onCameraDisconnected();
                    }
                }

                public void onCameraFreezed(String s) {
                    if (Stream.this.mStreamDelegate != null) {
                        Stream.this.mStreamDelegate.onEvent(VhallStreamEventType.CameraFreezed, s);
                    }
                    if (Stream.this.mCaptureBufferCallback != null) {
                        Stream.this.mCaptureBufferCallback.onCameraFreezed(s);
                    }
                }

                public void onCameraOpening(String s) {
                    if (Stream.this.mStreamDelegate != null) {
                        Stream.this.mStreamDelegate.onEvent(VhallStreamEventType.CameraOpening, s);
                    }
                    if (Stream.this.mCaptureBufferCallback != null) {
                        Stream.this.mCaptureBufferCallback.onCameraOpening(s);
                    }
                }

                public void onFirstFrameAvailable() {
                    if (Stream.this.mStreamDelegate != null) {
                        Stream.this.mStreamDelegate.onEvent(VhallStreamEventType.CameraFirstFrameAvailable, "onFirstFrameAvailable");
                    }
                    if (Stream.this.mCaptureBufferCallback != null) {
                        Stream.this.mCaptureBufferCallback.onFirstFrameAvailable();
                    }
                }

                public void onCameraClosed() {
                    if (Stream.this.mStreamDelegate != null) {
                        Stream.this.mStreamDelegate.onEvent(VhallStreamEventType.CameraClosed, "onCameraClosed");
                    }
                    if (Stream.this.mCaptureBufferCallback != null) {
                        Stream.this.mCaptureBufferCallback.onCameraClosed();
                    }
                }
            }, false);
            videoSource = this.mPeerFactory.createVideoSource(false);
            this.mVideoCapturerAndroid.initialize(this.mSurfaceTextureHelper, this.mApplicationContext, new CapturerObserver(){

                public void onCapturerStarted(boolean b) {
                    videoSource.getCapturerObserver().onCapturerStarted(b);
                }

                public void onCapturerStopped() {
                    videoSource.getCapturerObserver().onCapturerStopped();
                }

                public void onFrameCaptured(VideoFrame videoFrame) {
                    Stream.this.mLocalVideoFrame = videoFrame;
                    if (Stream.this.mPublishProportionHeight != 0 && Stream.this.mPublishProportionWidth != 0) {
                        int cropwidth = 0;
                        int cropheight = 0;
                        int scaledwidth = 0;
                        int scaledheight = 0;
                        switch (videoFrame.getRotation()) {
                            case 0: 
                            case 90: 
                            case 180: {
                                cropwidth = videoFrame.getRotatedWidth();
                                cropheight = videoFrame.getRotatedHeight();
                                break;
                            }
                            case 270: {
                                cropheight = videoFrame.getRotatedWidth();
                                cropwidth = videoFrame.getRotatedHeight();
                                break;
                            }
                        }
                        double diff_aspcet_ratio = (double)cropwidth / (double)cropheight - (double)Stream.this.mPublishProportionWidth / (double)Stream.this.mPublishProportionHeight;
                        if (Math.abs(diff_aspcet_ratio) < 0.05) {
                            scaledwidth = cropwidth;
                            scaledheight = cropheight;
                        } else {
                            boolean isVerticalPrior;
                            boolean bl = isVerticalPrior = (double)cropwidth / (double)cropheight < (double)Stream.this.mPublishProportionWidth / (double)Stream.this.mPublishProportionHeight;
                            if (cropwidth > cropheight) {
                                scaledwidth = Stream.this.MEMALIGN(cropwidth, 2);
                                scaledheight = Stream.this.MEMALIGN(scaledwidth * Stream.this.mPublishProportionHeight / Stream.this.mPublishProportionWidth, 2);
                            } else {
                                scaledheight = Stream.this.MEMALIGN(cropheight, 2);
                                scaledwidth = Stream.this.MEMALIGN(scaledheight * Stream.this.mPublishProportionHeight / Stream.this.mPublishProportionWidth, 2);
                            }
                        }
                        VideoFrame.Buffer f = videoFrame.getBuffer().cropAndScale(0, 0, cropwidth, cropheight, scaledwidth, scaledheight);
                        VideoFrame vf = new VideoFrame(f, videoFrame.getRotation(), videoFrame.getTimestampNs());
                        videoSource.getCapturerObserver().onFrameCaptured(vf);
                        vf.release();
                    } else {
                        videoSource.getCapturerObserver().onFrameCaptured(videoFrame);
                    }
                }
            });
            this.mVideoCapturerAndroid.startCapture(this.mVideoWidth, this.mVideoHeight, this.mFps);
        }
        videoTrack = this.mPeerFactory.createVideoTrack(kVHVideoTrackId, videoSource);
        return videoTrack;
    }

    public void startVideoCapture() {
        if (this.mVideoCapturerAndroid != null) {
            this.mVideoCapturerAndroid.startCapture(this.mVideoWidth, this.mVideoHeight, this.mFps);
        }
    }

    private AudioTrack createLocalAudioTrack() {
        AudioTrack audioTrack = null;
        if (this.mStreamType == VhallStreamType.VhallStreamTypeOnlyVideo.getValue()) {
            return audioTrack;
        }
        AudioSource audioSource = this.mPeerFactory.createAudioSource(this.audioConstraints);
        audioTrack = this.mPeerFactory.createAudioTrack(kVHAudioTrackId, audioSource);
        return audioTrack;
    }

    private void generateVideoTracks() {
        this.removeVideoTracks();
        VideoTrack localVideoTrack = this.createLocalVideoTrack();
        if (localVideoTrack != null) {
            this.mediaStream.addTrack(localVideoTrack);
        }
    }

    private void generateAudioTracks() {
        this.removeAudioTracks();
        AudioTrack localAudioTrack = this.createLocalAudioTrack();
        if (localAudioTrack != null) {
            this.mediaStream.addTrack(localAudioTrack);
        }
    }

    private void removeVideoTracks() {
        if (this.mediaStream == null) {
            return;
        }
        for (VideoTrack localTrack : this.mediaStream.videoTracks) {
            this.mediaStream.removeTrack(localTrack);
        }
    }

    private void removeAudioTracks() {
        if (this.mediaStream == null) {
            return;
        }
        for (AudioTrack localTrack : this.mediaStream.audioTracks) {
            this.mediaStream.removeTrack(localTrack);
        }
    }

    private void sendMuteStreamMsg(JSONObject muteStream, FinishCallback finish) {
        if (muteStream == null) {
            LogManager.e(mTAG, "muteStream==null");
            return;
        }
        JSONObject config = new JSONObject();
        try {
            config.put(kStreamOptionMuteStream, (Object)muteStream);
            config.put("localStream", this.isLocal);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.signalingChannel != null) {
            this.signalingChannel.sendMuteStream(this.streamId, config, finish);
        }
    }

    public static interface StatsReportCallback {
        public void onResponse(int var1, int var2, Map<String, String> var3);
    }

    public static interface CaptureBufferCallback {
        public int onVideoCaptureTex(int var1, int var2, int var3);

        public void onCameraSwitch(boolean var1);

        public void onCameraError(String var1);

        public void onCameraDisconnected();

        public void onCameraFreezed(String var1);

        public void onCameraOpening(String var1);

        public void onFirstFrameAvailable();

        public void onCameraClosed();
    }

    public static interface StatsCallback {
        public void onResponse(String var1, long var2, Map<String, String> var4);
    }

    public static enum VhallFrameResolutionValue {
        VhallFrameResolution192x144(0),
        VhallFrameResolution240x160(1),
        VhallFrameResolution320x240(2),
        VhallFrameResolution480x360(3),
        VhallFrameResolution570x432(4),
        VhallFrameResolution640x480(5);

        private int _value;

        private VhallFrameResolutionValue(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VhallStreamType {
        VhallStreamTypeOnlyAudio(0),
        VhallStreamTypeOnlyVideo(1),
        VhallStreamTypeAudioAndVideo(2),
        VhallStreamTypeScreen(3),
        VhallStreamTypeFile(4),
        VhallStreamTypeVideoPatrol(5),
        VhallStreamTypeCustom(6);

        private int _value;

        private VhallStreamType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static interface StreamDelegate {
        public void onEvent(VhallStreamEventType var1, String var2);

        public void onError(VhallStreamEventType var1, String var2);
    }

    public static enum VhallStreamEventType {
        VhallStreamEventTypeCameraError(0),
        CameraDisconnected(1),
        CameraFreezed(2),
        CameraOpening(3),
        CameraFirstFrameAvailable(4),
        CameraClosed(5);

        private int _value;

        private VhallStreamEventType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }
}

