package com.vhall.beautify;

import com.faceunity.core.faceunity.FURenderConfig;
import com.vhall.beautify.type.VHBeautifyCode;
import com.vhall.beautify.type.VHBeautifyParamConfig;

/**
 * @author：Jooper Email：jooperge@163.com
 * 描述：
 * 修改历史:
 * 1.vhKey初版参考FaceUnity定义，故该实现只需过滤vh_前缀即可
 * <p>
 * 创建于： 2022/1/10
 */
public class ParamMappingHelper {
    /**
     * @param vhKey
     * @return
     * @see VHBeautifyParamConfig
     */
    public static String mapping(String vhKey) {
        return vhKey.replace("vh_", "");
    }

    /**
     * 三方code转换为vh-code
     *
     * @param rawCode
     * @return
     */
    public static int mappingCode(int rawCode) {
        int vhCode = rawCode;
        switch (rawCode) {
            case FURenderConfig.OPERATE_FAILED_AUTH:
                vhCode = VHBeautifyCode.THIRD_FAILED_AUTH;
                break;
            case FURenderConfig.OPERATE_FAILED_FILE_NOT_FOUND:
                vhCode = VHBeautifyCode.THIRD_FAILED_FILE_NOTFOUND;
                break;
            case FURenderConfig.OPERATE_FAILED_LOAD_AI_MODEL:
                vhCode = VHBeautifyCode.THIRD_FAILED_LOAD_AI_MODEL;
                break;
            case FURenderConfig.OPERATE_FAILED_LOAD_BUNDLE:
                vhCode = VHBeautifyCode.THIRD_FAILED_LOAD_BUNDLE;
                break;
        }
        return vhCode;
    }
}
