/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.message;

import android.text.TextUtils;
import com.vhall.message.ConnectServer;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.net.URISyntaxException;
import org.json.JSONObject;

public final class MessageServer
implements ConnectServer {
    private static final String MSG_KEY = "msg";
    private static final String JOINED_KEY = "joined";
    private Socket mSocket;
    private ConnectServer.EventCallback mCallback;
    private ConnectServer.State mState = ConnectServer.State.STATE_DISCONNECT;
    private String mToken;
    private String url;
    private Emitter.Listener connect = new Emitter.Listener(){

        public void call(Object ... args) {
            MessageServer.this.mState = ConnectServer.State.STATE_CONNECTED;
            if (MessageServer.this.mCallback != null) {
                MessageServer.this.mCallback.onStateChanged(ConnectServer.State.STATE_CONNECTED);
            }
        }
    };
    private Emitter.Listener connect_error = new Emitter.Listener(){

        public void call(Object ... args) {
            MessageServer.this.mState = ConnectServer.State.STATE_DISCONNECT;
            if (MessageServer.this.mCallback != null) {
                MessageServer.this.mCallback.onStateChanged(ConnectServer.State.STATE_DISCONNECT);
            }
        }
    };
    private Emitter.Listener onDisconnect = new Emitter.Listener(){

        public void call(Object ... args) {
            MessageServer.this.mState = ConnectServer.State.STATE_DISCONNECT;
            if (MessageServer.this.mCallback != null) {
                MessageServer.this.mCallback.onStateChanged(ConnectServer.State.STATE_DISCONNECT);
            }
        }
    };
    private Emitter.Listener msg = new Emitter.Listener(){

        public void call(Object ... args) {
            String text = args[0].toString();
            if (MessageServer.this.mCallback != null) {
                MessageServer.this.mCallback.onMsg(text);
            }
        }
    };
    private Emitter.Listener joined = new Emitter.Listener(){

        public void call(Object ... args) {
            String text = args[0].toString();
            if (MessageServer.this.mCallback != null) {
                MessageServer.this.mCallback.onMsg(text);
            }
        }
    };

    public String getToken() {
        return this.mToken;
    }

    public String getUrl() {
        return this.url;
    }

    public void setToken(String token) {
        this.mToken = token;
    }

    @Override
    public void connect(String url) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)this.mToken)) {
            return;
        }
        if (this.mState == ConnectServer.State.STATE_CONNECTED) {
            return;
        }
        try {
            IO.Options options = new IO.Options();
            options.query = "token=" + this.mToken;
            options.reconnection = false;
            options.transports = new String[]{"websocket", "polling"};
            options.forceNew = true;
            this.url = url;
            this.mSocket = IO.socket((String)url, (IO.Options)options);
            this.mState = ConnectServer.State.STATE_CONNECTIONG;
            if (this.mCallback != null) {
                this.mCallback.onStateChanged(ConnectServer.State.STATE_CONNECTIONG);
            }
            this.mSocket.on("connect", this.connect);
            this.mSocket.on("connect_error", this.connect_error);
            this.mSocket.on("disconnect", this.onDisconnect);
            this.mSocket.on(MSG_KEY, this.msg);
            this.mSocket.on(JOINED_KEY, this.joined);
            this.mSocket.connect();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void disconnect() {
        if (this.mSocket != null && this.mSocket.connected()) {
            this.mSocket.off("connect", this.connect);
            this.mSocket.off("connect_error", this.connect_error);
            this.mSocket.off("disconnect", this.onDisconnect);
            this.mSocket.off(MSG_KEY, this.msg);
            this.mSocket.off(JOINED_KEY, this.joined);
            this.mSocket.disconnect();
            this.mSocket.close();
            this.mSocket = null;
            this.url = "";
            this.mToken = "";
            this.mState = ConnectServer.State.STATE_DISCONNECT;
        }
    }

    public Emitter on(String event, Emitter.Listener fn) {
        if (this.mSocket != null) {
            return this.mSocket.on(event, fn);
        }
        return null;
    }

    public Emitter off(String event, Emitter.Listener fn) {
        if (this.mSocket != null) {
            return this.mSocket.off(event, fn);
        }
        return null;
    }

    public void off(String event) {
        if (this.mSocket != null) {
            for (Emitter.Listener listener : this.mSocket.listeners(event)) {
                this.mSocket.off(event, listener);
            }
        }
    }

    @Override
    public void disconnectForce() {
        if (this.mSocket != null) {
            if (this.mSocket.connected()) {
                this.mSocket.off("connect", this.connect);
                this.mSocket.off("connect_error", this.connect_error);
                this.mSocket.off("disconnect", this.onDisconnect);
                this.mSocket.off(MSG_KEY, this.msg);
                this.mSocket.off(JOINED_KEY, this.joined);
            }
            this.mSocket.disconnect();
            this.mSocket.close();
            this.mSocket = null;
            this.url = "";
            this.mToken = "";
            this.mState = ConnectServer.State.STATE_DISCONNECT;
        }
    }

    @Override
    public void setEventCallback(ConnectServer.EventCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public ConnectServer.State getState() {
        return this.mState;
    }

    public void join(JSONObject object) {
        if (this.mSocket != null) {
            this.mSocket.emit("join", new Object[]{object});
        }
    }

    public void leave(JSONObject object) {
        if (this.mSocket != null) {
            this.mSocket.emit("leave", new Object[]{object});
        }
    }

    public void sendMsg(String event, String msg) {
        if (this.mSocket != null) {
            this.mSocket.emit(event, new Object[]{msg});
        }
    }

    public void sendMsg(String event, JSONObject object) {
        if (this.mSocket != null) {
            this.mSocket.emit(event, new Object[]{object});
        }
    }
}

