/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.message;

import android.text.TextUtils;
import com.vhall.message.ConnectServer;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public final class ChatServer
implements ConnectServer {
    private static final String TAG = "ChatServer";
    private WebSocket ws;
    private ConnectServer.EventCallback mCallback;
    private ConnectServer.State mState = ConnectServer.State.STATE_DISCONNECT;

    @Override
    public void connect(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        this.disconnect();
        this.mState = ConnectServer.State.STATE_CONNECTIONG;
        if (this.mCallback != null) {
            this.mCallback.onStateChanged(ConnectServer.State.STATE_CONNECTIONG);
        }
        OkHttpClient mOkHttpClient = new OkHttpClient.Builder().pingInterval(10L, TimeUnit.SECONDS).connectTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
        Request wsRequest = new Request.Builder().url(url).build();
        this.ws = mOkHttpClient.newWebSocket(wsRequest, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                ChatServer.this.mState = ConnectServer.State.STATE_CONNECTED;
                if (ChatServer.this.mCallback != null) {
                    ChatServer.this.mCallback.onStateChanged(ConnectServer.State.STATE_CONNECTED);
                }
            }

            public void onMessage(WebSocket webSocket, String text) {
                super.onMessage(webSocket, text);
                if (ChatServer.this.mCallback != null) {
                    ChatServer.this.mCallback.onMsg(text);
                }
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                super.onClosed(webSocket, code, reason);
                ChatServer.this.mState = ConnectServer.State.STATE_DISCONNECT;
                if (ChatServer.this.mCallback != null) {
                    ChatServer.this.mCallback.onStateChanged(ConnectServer.State.STATE_DISCONNECT);
                }
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                super.onFailure(webSocket, t, response);
                ChatServer.this.mState = ConnectServer.State.STATE_DISCONNECT;
                if (ChatServer.this.mCallback != null) {
                    ChatServer.this.mCallback.onStateChanged(ConnectServer.State.STATE_DISCONNECT);
                }
            }
        });
        mOkHttpClient.dispatcher().executorService().shutdown();
    }

    @Override
    public synchronized void disconnect() {
        try {
            if (this.ws != null) {
                this.ws.close(1000, "closed by user");
                this.ws.cancel();
                this.ws = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void disconnectForce() {
        this.disconnect();
    }

    @Override
    public void setEventCallback(ConnectServer.EventCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public ConnectServer.State getState() {
        return this.mState;
    }
}

