/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.utils;

import android.util.Log;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.httpclient.core.VHGlobalConfig;
import com.vhall.httpclient.impl.HttpLoggingInterceptor;
import com.vhall.httpclient.impl.interceptor.FormInterceptor;
import com.vhall.httpclient.impl.interceptor.HeaderInterceptor;
import com.vhall.httpclient.impl.interceptor.JsonInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OKHttpUtils {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static VHGlobalConfig config = new VHGlobalConfig.Builder().build();
    private static final long timeout = 15L;
    static OkHttpClient okHttpClient = null;
    static List<Interceptor> interceptors = new ArrayList<Interceptor>();

    public static void setConfig(VHGlobalConfig config) {
        OKHttpUtils.config = config;
    }

    public static OkHttpClient createOkClient() {
        if (okHttpClient != null) {
            return okHttpClient;
        }
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            @Override
            public void log(String message) {
                if (config != null) {
                    if (config.logEnable()) {
                        Log.e((String)config.getLogTag(), (String)message);
                    }
                    if (config.getCallback() != null) {
                        config.getCallback().log("", message);
                    }
                }
            }
        });
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS);
        for (Interceptor interceptor : interceptors) {
            builder.addInterceptor(interceptor);
        }
        if (config.getInterceptors() != null) {
            for (Interceptor interceptor : config.getInterceptors()) {
                builder.addInterceptor(interceptor);
            }
        }
        builder.addInterceptor((Interceptor)loggingInterceptor);
        okHttpClient = builder.build();
        return okHttpClient;
    }

    public static VHGlobalConfig getConfig() {
        return config;
    }

    public static Request buildRequest(IVHRequest request) {
        if (request.getFormParams() != null) {
            return OKHttpUtils.buildFormRequest(request);
        }
        if (request.getPostJson() != null) {
            return OKHttpUtils.buildJsonRequest(request);
        }
        return OKHttpUtils.buildGetRequest(request);
    }

    private static Request buildGetRequest(IVHRequest iRequest) {
        Request.Builder builder = new Request.Builder().url(iRequest.getUrl());
        if (iRequest.getHeader() != null && iRequest.getHeader().size() > 0) {
            for (String key : iRequest.getHeader().keySet()) {
                builder.addHeader(key, iRequest.getHeader().get(key));
            }
        }
        return builder.build();
    }

    private static Request buildJsonRequest(IVHRequest iRequest) {
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)iRequest.getPostJson());
        Request.Builder builder = new Request.Builder().url(iRequest.getUrl()).post(requestBody);
        if (iRequest.getHeader() != null && iRequest.getHeader().size() > 0) {
            for (String key : iRequest.getHeader().keySet()) {
                builder.addHeader(key, iRequest.getHeader().get(key));
            }
        }
        return builder.build();
    }

    private static Request buildFormRequest(IVHRequest iRequest) {
        FormBody.Builder builder = new FormBody.Builder();
        Map<String, String> params = iRequest.getFormParams();
        if (params != null && params.size() > 0) {
            for (String key : params.keySet()) {
                builder.add(key, params.get(key));
            }
        }
        Request.Builder requestBuilder = new Request.Builder().url(iRequest.getUrl()).post((RequestBody)builder.build());
        if (iRequest.getHeader() != null && iRequest.getHeader().size() > 0) {
            for (String key : iRequest.getHeader().keySet()) {
                requestBuilder.addHeader(key, iRequest.getHeader().get(key));
            }
        }
        return requestBuilder.build();
    }

    static {
        interceptors.add(new FormInterceptor());
        interceptors.add(new HeaderInterceptor());
        interceptors.add(new JsonInterceptor());
    }
}

