/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.impl.interceptor;

import com.vhall.httpclient.utils.OKHttpUtils;
import java.io.IOException;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class FormInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Map<String, String> pubParams = OKHttpUtils.getConfig().getPubParams();
        if (pubParams != null && pubParams.size() > 0 && request.body() instanceof FormBody) {
            FormBody.Builder builder = new FormBody.Builder();
            FormBody body = (FormBody)request.body();
            for (int i = 0; i < body.size(); ++i) {
                builder.add(body.encodedName(i), body.encodedValue(i));
            }
            for (String key : pubParams.keySet()) {
                builder.add(key, pubParams.get(key));
            }
            request = request.newBuilder().post((RequestBody)builder.build()).build();
        }
        Response response = chain.proceed(request);
        return response;
    }
}

