/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.impl;

import com.vhall.httpclient.core.BaseHttpConnection;
import com.vhall.httpclient.core.IVHNetRequestConfig;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.httpclient.utils.FormUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Map;

final class VHPostFormNetWork {
    private IVHNetRequestConfig ivhNetConfig;

    VHPostFormNetWork(IVHNetRequestConfig ivhNetConfig) {
        this.ivhNetConfig = ivhNetConfig;
    }

    public VHNetResponse postForm(String url, Map<String, String> params) {
        VHNetResponse.Builder builder = new VHNetResponse.Builder();
        try {
            HttpURLConnection urlConnection = BaseHttpConnection.selectConnection(url, this.ivhNetConfig).getHttpConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            if (params != null && params.size() > 0) {
                byte[] writeBytes = FormUtils.convertPostParams(params).getBytes();
                urlConnection.setRequestProperty("Content-Length", String.valueOf(writeBytes.length));
                OutputStream outputStream = urlConnection.getOutputStream();
                outputStream.write(writeBytes);
                outputStream.flush();
                outputStream.close();
            }
            int response = urlConnection.getResponseCode();
            builder.setResponseCode(response);
            if (response == 200) {
                InputStream inputStream = urlConnection.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder stringBuilder = new StringBuilder();
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                inputStream.close();
                bufferedReader.close();
                builder.setResult(stringBuilder.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            String message = "\u672a\u6355\u83b7\u5f02\u5e38";
            if (e != null) {
                message = e.getMessage();
            }
            builder.setErrorMessage(message);
        }
        return builder.build();
    }
}

