/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.core;

import com.vhall.httpclient.core.IVHNetLogCallback;
import com.vhall.httpclient.core.VHNetInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public interface VHGlobalConfig {
    public boolean logEnable();

    public String getLogTag();

    public IVHNetLogCallback getCallback();

    public Map<String, String> getPubHeaders();

    public JSONObject getPubJson();

    public String getPubJsonKey();

    public Map<String, String> getPubParams();

    public List<VHNetInterceptor> getInterceptors();

    public static class Builder {
        private boolean enableLog;
        private String logTag = "vhall_httpclient";
        private IVHNetLogCallback logCallback;
        private Map<String, String> pubHeaders;
        private JSONObject pubJson;
        private String pubJsonKey;
        private Map<String, String> pubParams;
        private List<VHNetInterceptor> vhNetInterceptors;

        public Builder setEnableLog(boolean enable) {
            this.enableLog = enable;
            return this;
        }

        public Builder setLogTag(String logTag) {
            this.logTag = logTag;
            return this;
        }

        public Builder setVHNetLogCallback(IVHNetLogCallback callback) {
            this.logCallback = callback;
            return this;
        }

        public Builder addHeader(String key, String value) {
            if (this.pubHeaders == null) {
                this.pubHeaders = new HashMap<String, String>();
            }
            this.pubHeaders.put(key, value);
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            if (this.pubHeaders == null) {
                this.pubHeaders = new HashMap<String, String>();
            }
            this.pubHeaders.putAll(headers);
            return this;
        }

        public Builder setPubJson(JSONObject json) {
            this.pubJson = json;
            return this;
        }

        public Builder setPubJsonKey(String pubJsonKey) {
            this.pubJsonKey = pubJsonKey;
            return this;
        }

        public Builder setPubJson(String pubJsonKey, JSONObject json) {
            this.pubJsonKey = pubJsonKey;
            this.pubJson = json;
            return this;
        }

        public Builder addParam(String key, String value) {
            if (this.pubParams == null) {
                this.pubParams = new HashMap<String, String>();
            }
            this.pubParams.put(key, value);
            return this;
        }

        public Builder addParams(Map<String, String> pubParams) {
            if (pubParams == null) {
                pubParams = new HashMap<String, String>();
            }
            pubParams.putAll(pubParams);
            return this;
        }

        public Builder addInterceptor(VHNetInterceptor interceptor) {
            if (this.vhNetInterceptors == null) {
                this.vhNetInterceptors = new ArrayList<VHNetInterceptor>();
            }
            this.vhNetInterceptors.add(interceptor);
            return this;
        }

        public VHGlobalConfig build() {
            return new VHGlobalConfig(){

                @Override
                public String getLogTag() {
                    return logTag;
                }

                @Override
                public boolean logEnable() {
                    return enableLog;
                }

                @Override
                public IVHNetLogCallback getCallback() {
                    return logCallback;
                }

                @Override
                public Map<String, String> getPubHeaders() {
                    return pubHeaders;
                }

                @Override
                public JSONObject getPubJson() {
                    return pubJson;
                }

                @Override
                public String getPubJsonKey() {
                    return pubJsonKey;
                }

                @Override
                public Map<String, String> getPubParams() {
                    return pubParams;
                }

                @Override
                public List<VHNetInterceptor> getInterceptors() {
                    return vhNetInterceptors;
                }
            };
        }
    }
}

