/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.core;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public interface IVHRequest {
    public String getBaseUrl();

    public String getUrl();

    public Map<String, String> getHeader();

    public Map<String, String> getFormParams();

    public String getPostJson();

    public static class Builder {
        private String baseUrl;
        private String url;
        private Map<String, String> headers;
        private Map<String, String> formParams;
        private String json;

        public Builder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder addHeader(String key, String value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.putAll(headers);
            return this;
        }

        public Builder addFormParas(Map<String, String> formParams) {
            if (this.formParams == null) {
                this.formParams = new HashMap<String, String>();
            }
            this.formParams.putAll(formParams);
            return this;
        }

        public Builder addFormParam(String key, String value) {
            if (this.formParams == null) {
                this.formParams = new HashMap<String, String>();
            }
            this.formParams.put(key, value);
            return this;
        }

        public Builder setJson(JSONObject params) {
            if (params != null) {
                this.json = params.toString();
            }
            return this;
        }

        public String getRequestUrl() {
            if (this.url.startsWith("http")) {
                return this.url;
            }
            return String.format("%s%s", this.baseUrl, this.url);
        }

        public IVHRequest build() {
            return new IVHRequest(){

                @Override
                public String getBaseUrl() {
                    return baseUrl;
                }

                @Override
                public String getUrl() {
                    return this.getRequestUrl();
                }

                @Override
                public Map<String, String> getHeader() {
                    return headers;
                }

                @Override
                public Map<String, String> getFormParams() {
                    return formParams;
                }

                @Override
                public String getPostJson() {
                    return json;
                }
            };
        }
    }
}

