/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.api;

import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.httpclient.utils.ExecutorUtils;
import com.vhall.httpclient.utils.OKHttpUtils;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

final class VHNetInternal {
    VHNetInternal() {
    }

    static String doPostImpl(IVHRequest request) {
        try {
            return OKHttpUtils.createOkClient().newCall(OKHttpUtils.buildRequest(request)).execute().body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void doPostImpl(IVHRequest request, final IVHNetCallback callback) {
        OKHttpUtils.createOkClient().newCall(OKHttpUtils.buildRequest(request)).enqueue(new Callback(){

            public void onFailure(Call call, final IOException e) {
                ExecutorUtils.postUiThread(new Runnable(){

                    @Override
                    public void run() {
                        VHNetResponse response = new VHNetResponse.Builder().setErrorMessage(e.getMessage()).build();
                        callback.onFailure(response, e);
                    }
                });
            }

            public void onResponse(Call call, final Response response) {
                ExecutorUtils.postUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VHNetResponse vhNetResponse = new VHNetResponse.Builder().setResult(response.body().string()).setResponseCode(response.code()).build();
                            callback.response(vhNetResponse);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }
}

