/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.source.smoothstreaming.offline;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.vhall.android.exoplayer2.offline.DownloadHelper;
import com.vhall.android.exoplayer2.offline.StreamKey;
import com.vhall.android.exoplayer2.offline.TrackKey;
import com.vhall.android.exoplayer2.source.TrackGroup;
import com.vhall.android.exoplayer2.source.TrackGroupArray;
import com.vhall.android.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.vhall.android.exoplayer2.source.smoothstreaming.manifest.SsManifestParser;
import com.vhall.android.exoplayer2.source.smoothstreaming.offline.SsDownloadAction;
import com.vhall.android.exoplayer2.upstream.DataSource;
import com.vhall.android.exoplayer2.upstream.ParsingLoadable;
import com.vhall.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class SsDownloadHelper
extends DownloadHelper {
    private final Uri uri;
    private final DataSource.Factory manifestDataSourceFactory;
    private @MonotonicNonNull SsManifest manifest;

    public SsDownloadHelper(Uri uri, DataSource.Factory manifestDataSourceFactory) {
        this.uri = uri;
        this.manifestDataSourceFactory = manifestDataSourceFactory;
    }

    protected void prepareInternal() throws IOException {
        DataSource dataSource = this.manifestDataSourceFactory.createDataSource();
        this.manifest = (SsManifest)ParsingLoadable.load((DataSource)dataSource, (ParsingLoadable.Parser)new SsManifestParser(), (Uri)this.uri, (int)4);
    }

    public SsManifest getManifest() {
        Assertions.checkNotNull((Object)this.manifest);
        return this.manifest;
    }

    public int getPeriodCount() {
        Assertions.checkNotNull((Object)this.manifest);
        return 1;
    }

    public TrackGroupArray getTrackGroups(int periodIndex) {
        Assertions.checkNotNull((Object)this.manifest);
        SsManifest.StreamElement[] streamElements = this.manifest.streamElements;
        TrackGroup[] trackGroups = new TrackGroup[streamElements.length];
        for (int i = 0; i < streamElements.length; ++i) {
            trackGroups[i] = new TrackGroup(streamElements[i].formats);
        }
        return new TrackGroupArray(trackGroups);
    }

    public SsDownloadAction getDownloadAction(@Nullable byte[] data, List<TrackKey> trackKeys) {
        return SsDownloadAction.createDownloadAction(this.uri, data, SsDownloadHelper.toStreamKeys(trackKeys));
    }

    public SsDownloadAction getRemoveAction(@Nullable byte[] data) {
        return SsDownloadAction.createRemoveAction(this.uri, data);
    }

    private static List<StreamKey> toStreamKeys(List<TrackKey> trackKeys) {
        ArrayList<StreamKey> representationKeys = new ArrayList<StreamKey>(trackKeys.size());
        for (int i = 0; i < trackKeys.size(); ++i) {
            TrackKey trackKey = trackKeys.get(i);
            representationKeys.add(new StreamKey(trackKey.groupIndex, trackKey.trackIndex));
        }
        return representationKeys;
    }
}

