/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.source.hls.offline;

import android.net.Uri;
import com.vhall.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.vhall.android.exoplayer2.offline.SegmentDownloader;
import com.vhall.android.exoplayer2.offline.StreamKey;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsPlaylistParser;
import com.vhall.android.exoplayer2.upstream.DataSource;
import com.vhall.android.exoplayer2.upstream.DataSpec;
import com.vhall.android.exoplayer2.upstream.ParsingLoadable;
import com.vhall.android.exoplayer2.util.UriUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class HlsDownloader
extends SegmentDownloader<HlsPlaylist> {
    public HlsDownloader(Uri playlistUri, List<StreamKey> streamKeys, DownloaderConstructorHelper constructorHelper) {
        super(playlistUri, streamKeys, constructorHelper);
    }

    protected HlsPlaylist getManifest(DataSource dataSource, Uri uri) throws IOException {
        return HlsDownloader.loadManifest(dataSource, uri);
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, HlsPlaylist playlist, boolean allowIncompleteList) throws IOException {
        ArrayList<Uri> mediaPlaylistUris = new ArrayList<Uri>();
        if (playlist instanceof HlsMasterPlaylist) {
            HlsMasterPlaylist masterPlaylist = (HlsMasterPlaylist)playlist;
            HlsDownloader.addResolvedUris(masterPlaylist.baseUri, masterPlaylist.variants, mediaPlaylistUris);
            HlsDownloader.addResolvedUris(masterPlaylist.baseUri, masterPlaylist.audios, mediaPlaylistUris);
            HlsDownloader.addResolvedUris(masterPlaylist.baseUri, masterPlaylist.subtitles, mediaPlaylistUris);
        } else {
            mediaPlaylistUris.add(Uri.parse((String)playlist.baseUri));
        }
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        HashSet<Uri> seenEncryptionKeyUris = new HashSet<Uri>();
        for (Uri mediaPlaylistUri : mediaPlaylistUris) {
            HlsMediaPlaylist mediaPlaylist;
            try {
                mediaPlaylist = (HlsMediaPlaylist)HlsDownloader.loadManifest(dataSource, mediaPlaylistUri);
                segments.add(new SegmentDownloader.Segment(mediaPlaylist.startTimeUs, new DataSpec(mediaPlaylistUri)));
            }
            catch (IOException e) {
                if (!allowIncompleteList) {
                    throw e;
                }
                segments.add(new SegmentDownloader.Segment(0L, new DataSpec(mediaPlaylistUri)));
                continue;
            }
            HlsMediaPlaylist.Segment lastInitSegment = null;
            List<HlsMediaPlaylist.Segment> hlsSegments = mediaPlaylist.segments;
            for (int i = 0; i < hlsSegments.size(); ++i) {
                HlsMediaPlaylist.Segment segment = hlsSegments.get(i);
                HlsMediaPlaylist.Segment initSegment = segment.initializationSegment;
                if (initSegment != null && initSegment != lastInitSegment) {
                    lastInitSegment = initSegment;
                    HlsDownloader.addSegment(segments, mediaPlaylist, initSegment, seenEncryptionKeyUris);
                }
                HlsDownloader.addSegment(segments, mediaPlaylist, segment, seenEncryptionKeyUris);
            }
        }
        return segments;
    }

    private static HlsPlaylist loadManifest(DataSource dataSource, Uri uri) throws IOException {
        return (HlsPlaylist)ParsingLoadable.load((DataSource)dataSource, (ParsingLoadable.Parser)new HlsPlaylistParser(), (Uri)uri, (int)4);
    }

    private static void addSegment(ArrayList<SegmentDownloader.Segment> segments, HlsMediaPlaylist mediaPlaylist, HlsMediaPlaylist.Segment hlsSegment, HashSet<Uri> seenEncryptionKeyUris) {
        Uri keyUri;
        long startTimeUs = mediaPlaylist.startTimeUs + hlsSegment.relativeStartTimeUs;
        if (hlsSegment.fullSegmentEncryptionKeyUri != null && seenEncryptionKeyUris.add(keyUri = UriUtil.resolveToUri((String)mediaPlaylist.baseUri, (String)hlsSegment.fullSegmentEncryptionKeyUri))) {
            segments.add(new SegmentDownloader.Segment(startTimeUs, new DataSpec(keyUri)));
        }
        Uri resolvedUri = UriUtil.resolveToUri((String)mediaPlaylist.baseUri, (String)hlsSegment.url);
        segments.add(new SegmentDownloader.Segment(startTimeUs, new DataSpec(resolvedUri, hlsSegment.byterangeOffset, hlsSegment.byterangeLength, null)));
    }

    private static void addResolvedUris(String baseUri, List<HlsMasterPlaylist.HlsUrl> urls, List<Uri> out) {
        for (int i = 0; i < urls.size(); ++i) {
            out.add(UriUtil.resolveToUri((String)baseUri, (String)urls.get((int)i).url));
        }
    }
}

