/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.source.hls;

import android.support.annotation.Nullable;
import com.vhall.android.exoplayer2.Format;
import com.vhall.android.exoplayer2.SeekParameters;
import com.vhall.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.vhall.android.exoplayer2.source.MediaPeriod;
import com.vhall.android.exoplayer2.source.MediaSourceEventListener;
import com.vhall.android.exoplayer2.source.SampleStream;
import com.vhall.android.exoplayer2.source.SequenceableLoader;
import com.vhall.android.exoplayer2.source.TrackGroup;
import com.vhall.android.exoplayer2.source.TrackGroupArray;
import com.vhall.android.exoplayer2.source.hls.HlsChunkSource;
import com.vhall.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.vhall.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.vhall.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.vhall.android.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.vhall.android.exoplayer2.trackselection.TrackSelection;
import com.vhall.android.exoplayer2.upstream.Allocator;
import com.vhall.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.vhall.android.exoplayer2.upstream.TransferListener;
import com.vhall.android.exoplayer2.util.Assertions;
import com.vhall.android.exoplayer2.util.MimeTypes;
import com.vhall.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;

public final class HlsMediaPeriod
implements MediaPeriod,
HlsSampleStreamWrapper.Callback,
HlsPlaylistTracker.PlaylistEventListener {
    private final HlsExtractorFactory extractorFactory;
    private final HlsPlaylistTracker playlistTracker;
    private final HlsDataSourceFactory dataSourceFactory;
    @Nullable
    private final TransferListener mediaTransferListener;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final Allocator allocator;
    private final IdentityHashMap<SampleStream, Integer> streamWrapperIndices;
    private final TimestampAdjusterProvider timestampAdjusterProvider;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final boolean allowChunklessPreparation;
    @Nullable
    private MediaPeriod.Callback callback;
    private int pendingPrepareCount;
    private TrackGroupArray trackGroups;
    private HlsSampleStreamWrapper[] sampleStreamWrappers;
    private HlsSampleStreamWrapper[] enabledSampleStreamWrappers;
    private SequenceableLoader compositeSequenceableLoader;
    private boolean notifiedReadingStarted;

    public HlsMediaPeriod(HlsExtractorFactory extractorFactory, HlsPlaylistTracker playlistTracker, HlsDataSourceFactory dataSourceFactory, @Nullable TransferListener mediaTransferListener, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher, Allocator allocator, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, boolean allowChunklessPreparation) {
        this.extractorFactory = extractorFactory;
        this.playlistTracker = playlistTracker;
        this.dataSourceFactory = dataSourceFactory;
        this.mediaTransferListener = mediaTransferListener;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.eventDispatcher = eventDispatcher;
        this.allocator = allocator;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.allowChunklessPreparation = allowChunklessPreparation;
        this.compositeSequenceableLoader = compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(new SequenceableLoader[0]);
        this.streamWrapperIndices = new IdentityHashMap();
        this.timestampAdjusterProvider = new TimestampAdjusterProvider();
        this.sampleStreamWrappers = new HlsSampleStreamWrapper[0];
        this.enabledSampleStreamWrappers = new HlsSampleStreamWrapper[0];
        eventDispatcher.mediaPeriodCreated();
    }

    public void release() {
        this.playlistTracker.removeListener(this);
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            sampleStreamWrapper.release();
        }
        this.callback = null;
        this.eventDispatcher.mediaPeriodReleased();
    }

    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        this.playlistTracker.addListener(this);
        this.buildAndPrepareSampleStreamWrappers(positionUs);
    }

    public void maybeThrowPrepareError() throws IOException {
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            sampleStreamWrapper.maybeThrowPrepareError();
        }
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public long selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int[] streamChildIndices = new int[selections.length];
        int[] selectionChildIndices = new int[selections.length];
        block0: for (int i = 0; i < selections.length; ++i) {
            streamChildIndices[i] = streams[i] == null ? -1 : this.streamWrapperIndices.get(streams[i]);
            selectionChildIndices[i] = -1;
            if (selections[i] == null) continue;
            TrackGroup trackGroup = selections[i].getTrackGroup();
            for (int j = 0; j < this.sampleStreamWrappers.length; ++j) {
                if (this.sampleStreamWrappers[j].getTrackGroups().indexOf(trackGroup) == -1) continue;
                selectionChildIndices[i] = j;
                continue block0;
            }
        }
        boolean forceReset = false;
        this.streamWrapperIndices.clear();
        SampleStream[] newStreams = new SampleStream[selections.length];
        SampleStream[] childStreams = new SampleStream[selections.length];
        TrackSelection[] childSelections = new TrackSelection[selections.length];
        int newEnabledSampleStreamWrapperCount = 0;
        HlsSampleStreamWrapper[] newEnabledSampleStreamWrappers = new HlsSampleStreamWrapper[this.sampleStreamWrappers.length];
        for (int i = 0; i < this.sampleStreamWrappers.length; ++i) {
            for (int j = 0; j < selections.length; ++j) {
                childStreams[j] = streamChildIndices[j] == i ? streams[j] : null;
                childSelections[j] = selectionChildIndices[j] == i ? selections[j] : null;
            }
            HlsSampleStreamWrapper sampleStreamWrapper = this.sampleStreamWrappers[i];
            boolean wasReset = sampleStreamWrapper.selectTracks(childSelections, mayRetainStreamFlags, childStreams, streamResetFlags, positionUs, forceReset);
            boolean wrapperEnabled = false;
            for (int j = 0; j < selections.length; ++j) {
                if (selectionChildIndices[j] == i) {
                    Assertions.checkState((childStreams[j] != null ? 1 : 0) != 0);
                    newStreams[j] = childStreams[j];
                    wrapperEnabled = true;
                    this.streamWrapperIndices.put(childStreams[j], i);
                    continue;
                }
                if (streamChildIndices[j] != i) continue;
                Assertions.checkState((childStreams[j] == null ? 1 : 0) != 0);
            }
            if (!wrapperEnabled) continue;
            newEnabledSampleStreamWrappers[newEnabledSampleStreamWrapperCount] = sampleStreamWrapper;
            if (newEnabledSampleStreamWrapperCount++ == 0) {
                sampleStreamWrapper.setIsTimestampMaster(true);
                if (!wasReset && this.enabledSampleStreamWrappers.length != 0 && sampleStreamWrapper == this.enabledSampleStreamWrappers[0]) continue;
                this.timestampAdjusterProvider.reset();
                forceReset = true;
                continue;
            }
            sampleStreamWrapper.setIsTimestampMaster(false);
        }
        System.arraycopy(newStreams, 0, streams, 0, newStreams.length);
        this.enabledSampleStreamWrappers = Arrays.copyOf(newEnabledSampleStreamWrappers, newEnabledSampleStreamWrapperCount);
        this.compositeSequenceableLoader = this.compositeSequenceableLoaderFactory.createCompositeSequenceableLoader((SequenceableLoader[])this.enabledSampleStreamWrappers);
        return positionUs;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.enabledSampleStreamWrappers) {
            sampleStreamWrapper.discardBuffer(positionUs, toKeyframe);
        }
    }

    public void reevaluateBuffer(long positionUs) {
        this.compositeSequenceableLoader.reevaluateBuffer(positionUs);
    }

    public boolean continueLoading(long positionUs) {
        if (this.trackGroups == null) {
            for (HlsSampleStreamWrapper wrapper : this.sampleStreamWrappers) {
                wrapper.continuePreparing();
            }
            return false;
        }
        return this.compositeSequenceableLoader.continueLoading(positionUs);
    }

    public long getNextLoadPositionUs() {
        return this.compositeSequenceableLoader.getNextLoadPositionUs();
    }

    public long readDiscontinuity() {
        if (!this.notifiedReadingStarted) {
            this.eventDispatcher.readingStarted();
            this.notifiedReadingStarted = true;
        }
        return -9223372036854775807L;
    }

    public long getBufferedPositionUs() {
        return this.compositeSequenceableLoader.getBufferedPositionUs();
    }

    public long seekToUs(long positionUs) {
        if (this.enabledSampleStreamWrappers.length > 0) {
            boolean forceReset = this.enabledSampleStreamWrappers[0].seekToUs(positionUs, false);
            for (int i = 1; i < this.enabledSampleStreamWrappers.length; ++i) {
                this.enabledSampleStreamWrappers[i].seekToUs(positionUs, forceReset);
            }
            if (forceReset) {
                this.timestampAdjusterProvider.reset();
            }
        }
        return positionUs;
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return positionUs;
    }

    @Override
    public void onPrepared() {
        if (--this.pendingPrepareCount > 0) {
            return;
        }
        int totalTrackGroupCount = 0;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            totalTrackGroupCount += sampleStreamWrapper.getTrackGroups().length;
        }
        TrackGroup[] trackGroupArray = new TrackGroup[totalTrackGroupCount];
        int trackGroupIndex = 0;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            int wrapperTrackGroupCount = sampleStreamWrapper.getTrackGroups().length;
            for (int j = 0; j < wrapperTrackGroupCount; ++j) {
                trackGroupArray[trackGroupIndex++] = sampleStreamWrapper.getTrackGroups().get(j);
            }
        }
        this.trackGroups = new TrackGroupArray(trackGroupArray);
        this.callback.onPrepared((MediaPeriod)this);
    }

    @Override
    public void onPlaylistRefreshRequired(HlsMasterPlaylist.HlsUrl url) {
        this.playlistTracker.refreshPlaylist(url);
    }

    public void onContinueLoadingRequested(HlsSampleStreamWrapper sampleStreamWrapper) {
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    @Override
    public void onPlaylistChanged() {
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    @Override
    public boolean onPlaylistError(HlsMasterPlaylist.HlsUrl url, long blacklistDurationMs) {
        boolean noBlacklistingFailure = true;
        for (HlsSampleStreamWrapper streamWrapper : this.sampleStreamWrappers) {
            noBlacklistingFailure &= streamWrapper.onPlaylistError(url, blacklistDurationMs);
        }
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
        return noBlacklistingFailure;
    }

    private void buildAndPrepareSampleStreamWrappers(long positionUs) {
        HlsSampleStreamWrapper sampleStreamWrapper;
        int i;
        HlsMasterPlaylist masterPlaylist = this.playlistTracker.getMasterPlaylist();
        List<HlsMasterPlaylist.HlsUrl> audioRenditions = masterPlaylist.audios;
        List<HlsMasterPlaylist.HlsUrl> subtitleRenditions = masterPlaylist.subtitles;
        int wrapperCount = 1 + audioRenditions.size() + subtitleRenditions.size();
        this.sampleStreamWrappers = new HlsSampleStreamWrapper[wrapperCount];
        this.pendingPrepareCount = wrapperCount;
        this.buildAndPrepareMainSampleStreamWrapper(masterPlaylist, positionUs);
        int currentWrapperIndex = 1;
        for (i = 0; i < audioRenditions.size(); ++i) {
            HlsMasterPlaylist.HlsUrl audioRendition = audioRenditions.get(i);
            sampleStreamWrapper = this.buildSampleStreamWrapper(1, new HlsMasterPlaylist.HlsUrl[]{audioRendition}, null, Collections.emptyList(), positionUs);
            this.sampleStreamWrappers[currentWrapperIndex++] = sampleStreamWrapper;
            Format renditionFormat = audioRendition.format;
            if (this.allowChunklessPreparation && renditionFormat.codecs != null) {
                sampleStreamWrapper.prepareWithMasterPlaylistInfo(new TrackGroupArray(new TrackGroup[]{new TrackGroup(new Format[]{audioRendition.format})}), 0, TrackGroupArray.EMPTY);
                continue;
            }
            sampleStreamWrapper.continuePreparing();
        }
        for (i = 0; i < subtitleRenditions.size(); ++i) {
            HlsMasterPlaylist.HlsUrl url = subtitleRenditions.get(i);
            sampleStreamWrapper = this.buildSampleStreamWrapper(3, new HlsMasterPlaylist.HlsUrl[]{url}, null, Collections.emptyList(), positionUs);
            this.sampleStreamWrappers[currentWrapperIndex++] = sampleStreamWrapper;
            sampleStreamWrapper.prepareWithMasterPlaylistInfo(new TrackGroupArray(new TrackGroup[]{new TrackGroup(new Format[]{url.format})}), 0, TrackGroupArray.EMPTY);
        }
        this.enabledSampleStreamWrappers = this.sampleStreamWrappers;
    }

    private void buildAndPrepareMainSampleStreamWrapper(HlsMasterPlaylist masterPlaylist, long positionUs) {
        HlsSampleStreamWrapper sampleStreamWrapper;
        ArrayList<HlsMasterPlaylist.HlsUrl> selectedVariants = new ArrayList<HlsMasterPlaylist.HlsUrl>(masterPlaylist.variants);
        ArrayList<HlsMasterPlaylist.HlsUrl> definiteVideoVariants = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        ArrayList<HlsMasterPlaylist.HlsUrl> definiteAudioOnlyVariants = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        for (int i = 0; i < selectedVariants.size(); ++i) {
            HlsMasterPlaylist.HlsUrl variant = (HlsMasterPlaylist.HlsUrl)selectedVariants.get(i);
            Format format = variant.format;
            if (format.height > 0 || Util.getCodecsOfType((String)format.codecs, (int)2) != null) {
                definiteVideoVariants.add(variant);
                continue;
            }
            if (Util.getCodecsOfType((String)format.codecs, (int)1) == null) continue;
            definiteAudioOnlyVariants.add(variant);
        }
        if (!definiteVideoVariants.isEmpty()) {
            selectedVariants = definiteVideoVariants;
        } else if (definiteAudioOnlyVariants.size() < selectedVariants.size()) {
            selectedVariants.removeAll(definiteAudioOnlyVariants);
        }
        Assertions.checkArgument((!selectedVariants.isEmpty() ? 1 : 0) != 0);
        HlsMasterPlaylist.HlsUrl[] variants = selectedVariants.toArray(new HlsMasterPlaylist.HlsUrl[0]);
        String codecs = variants[0].format.codecs;
        this.sampleStreamWrappers[0] = sampleStreamWrapper = this.buildSampleStreamWrapper(0, variants, masterPlaylist.muxedAudioFormat, masterPlaylist.muxedCaptionFormats, positionUs);
        if (this.allowChunklessPreparation && codecs != null) {
            boolean variantsContainVideoCodecs = Util.getCodecsOfType((String)codecs, (int)2) != null;
            boolean variantsContainAudioCodecs = Util.getCodecsOfType((String)codecs, (int)1) != null;
            ArrayList<TrackGroup> muxedTrackGroups = new ArrayList<TrackGroup>();
            if (variantsContainVideoCodecs) {
                List<Format> ccFormats;
                Format[] videoFormats = new Format[selectedVariants.size()];
                for (int i = 0; i < videoFormats.length; ++i) {
                    videoFormats[i] = HlsMediaPeriod.deriveVideoFormat(variants[i].format);
                }
                muxedTrackGroups.add(new TrackGroup(videoFormats));
                if (variantsContainAudioCodecs && (masterPlaylist.muxedAudioFormat != null || masterPlaylist.audios.isEmpty())) {
                    muxedTrackGroups.add(new TrackGroup(new Format[]{HlsMediaPeriod.deriveAudioFormat(variants[0].format, masterPlaylist.muxedAudioFormat, false)}));
                }
                if ((ccFormats = masterPlaylist.muxedCaptionFormats) != null) {
                    for (int i = 0; i < ccFormats.size(); ++i) {
                        muxedTrackGroups.add(new TrackGroup(new Format[]{ccFormats.get(i)}));
                    }
                }
            } else if (variantsContainAudioCodecs) {
                Format[] audioFormats = new Format[selectedVariants.size()];
                for (int i = 0; i < audioFormats.length; ++i) {
                    Format variantFormat = variants[i].format;
                    audioFormats[i] = HlsMediaPeriod.deriveAudioFormat(variantFormat, masterPlaylist.muxedAudioFormat, true);
                }
                muxedTrackGroups.add(new TrackGroup(audioFormats));
            } else {
                throw new IllegalArgumentException("Unexpected codecs attribute: " + codecs);
            }
            TrackGroup id3TrackGroup = new TrackGroup(new Format[]{Format.createSampleFormat((String)"ID3", (String)"application/id3", null, (int)-1, null)});
            muxedTrackGroups.add(id3TrackGroup);
            sampleStreamWrapper.prepareWithMasterPlaylistInfo(new TrackGroupArray(muxedTrackGroups.toArray(new TrackGroup[0])), 0, new TrackGroupArray(new TrackGroup[]{id3TrackGroup}));
        } else {
            sampleStreamWrapper.setIsTimestampMaster(true);
            sampleStreamWrapper.continuePreparing();
        }
    }

    private HlsSampleStreamWrapper buildSampleStreamWrapper(int trackType, HlsMasterPlaylist.HlsUrl[] variants, Format muxedAudioFormat, List<Format> muxedCaptionFormats, long positionUs) {
        HlsChunkSource defaultChunkSource = new HlsChunkSource(this.extractorFactory, this.playlistTracker, variants, this.dataSourceFactory, this.mediaTransferListener, this.timestampAdjusterProvider, muxedCaptionFormats);
        return new HlsSampleStreamWrapper(trackType, this, defaultChunkSource, this.allocator, positionUs, muxedAudioFormat, this.loadErrorHandlingPolicy, this.eventDispatcher);
    }

    private static Format deriveVideoFormat(Format variantFormat) {
        String codecs = Util.getCodecsOfType((String)variantFormat.codecs, (int)2);
        String sampleMimeType = MimeTypes.getMediaMimeType((String)codecs);
        return Format.createVideoContainerFormat((String)variantFormat.id, (String)variantFormat.label, (String)variantFormat.containerMimeType, (String)sampleMimeType, (String)codecs, (int)variantFormat.bitrate, (int)variantFormat.width, (int)variantFormat.height, (float)variantFormat.frameRate, null, (int)variantFormat.selectionFlags);
    }

    private static Format deriveAudioFormat(Format variantFormat, Format mediaTagFormat, boolean isPrimaryTrackInVariant) {
        String codecs;
        int channelCount = -1;
        int selectionFlags = 0;
        String language = null;
        String label = null;
        if (mediaTagFormat != null) {
            codecs = mediaTagFormat.codecs;
            channelCount = mediaTagFormat.channelCount;
            selectionFlags = mediaTagFormat.selectionFlags;
            language = mediaTagFormat.language;
            label = mediaTagFormat.label;
        } else {
            codecs = Util.getCodecsOfType((String)variantFormat.codecs, (int)1);
            if (isPrimaryTrackInVariant) {
                channelCount = variantFormat.channelCount;
                selectionFlags = variantFormat.selectionFlags;
                language = variantFormat.label;
                label = variantFormat.label;
            }
        }
        String sampleMimeType = MimeTypes.getMediaMimeType((String)codecs);
        int bitrate = isPrimaryTrackInVariant ? variantFormat.bitrate : -1;
        return Format.createAudioContainerFormat((String)variantFormat.id, (String)label, (String)variantFormat.containerMimeType, (String)sampleMimeType, (String)codecs, (int)bitrate, (int)channelCount, (int)-1, null, (int)selectionFlags, (String)language);
    }
}

