/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.source.hls;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.vhall.android.exoplayer2.Format;
import com.vhall.android.exoplayer2.drm.DrmInitData;
import com.vhall.android.exoplayer2.extractor.Extractor;
import com.vhall.android.exoplayer2.extractor.ExtractorInput;
import com.vhall.android.exoplayer2.extractor.mp3.Mp3Extractor;
import com.vhall.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.vhall.android.exoplayer2.extractor.ts.Ac3Extractor;
import com.vhall.android.exoplayer2.extractor.ts.AdtsExtractor;
import com.vhall.android.exoplayer2.extractor.ts.DefaultTsPayloadReaderFactory;
import com.vhall.android.exoplayer2.extractor.ts.TsExtractor;
import com.vhall.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.vhall.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.vhall.android.exoplayer2.source.hls.WebvttExtractor;
import com.vhall.android.exoplayer2.util.MimeTypes;
import com.vhall.android.exoplayer2.util.TimestampAdjuster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DefaultHlsExtractorFactory
implements HlsExtractorFactory {
    public static final String AAC_FILE_EXTENSION = ".aac";
    public static final String AC3_FILE_EXTENSION = ".ac3";
    public static final String EC3_FILE_EXTENSION = ".ec3";
    public static final String MP3_FILE_EXTENSION = ".mp3";
    public static final String MP4_FILE_EXTENSION = ".mp4";
    public static final String M4_FILE_EXTENSION_PREFIX = ".m4";
    public static final String MP4_FILE_EXTENSION_PREFIX = ".mp4";
    public static final String CMF_FILE_EXTENSION_PREFIX = ".cmf";
    public static final String VTT_FILE_EXTENSION = ".vtt";
    public static final String WEBVTT_FILE_EXTENSION = ".webvtt";
    private final int payloadReaderFactoryFlags;

    public DefaultHlsExtractorFactory() {
        this(0);
    }

    public DefaultHlsExtractorFactory(int payloadReaderFactoryFlags) {
        this.payloadReaderFactoryFlags = payloadReaderFactoryFlags;
    }

    @Override
    public Pair<Extractor, Boolean> createExtractor(Extractor previousExtractor, Uri uri, Format format, List<Format> muxedCaptionFormats, DrmInitData drmInitData, TimestampAdjuster timestampAdjuster, Map<String, List<String>> responseHeaders, ExtractorInput extractorInput) throws InterruptedException, IOException {
        TsExtractor tsExtractor;
        FragmentedMp4Extractor fragmentedMp4Extractor;
        Mp3Extractor mp3Extractor;
        Ac3Extractor ac3Extractor;
        AdtsExtractor adtsExtractor;
        WebvttExtractor webvttExtractor;
        if (previousExtractor != null) {
            if (previousExtractor instanceof TsExtractor || previousExtractor instanceof FragmentedMp4Extractor) {
                return DefaultHlsExtractorFactory.buildResult(previousExtractor);
            }
            if (previousExtractor instanceof WebvttExtractor) {
                return DefaultHlsExtractorFactory.buildResult(new WebvttExtractor(format.language, timestampAdjuster));
            }
            if (previousExtractor instanceof AdtsExtractor) {
                return DefaultHlsExtractorFactory.buildResult((Extractor)new AdtsExtractor());
            }
            if (previousExtractor instanceof Ac3Extractor) {
                return DefaultHlsExtractorFactory.buildResult((Extractor)new Ac3Extractor());
            }
            if (previousExtractor instanceof Mp3Extractor) {
                return DefaultHlsExtractorFactory.buildResult((Extractor)new Mp3Extractor());
            }
            throw new IllegalArgumentException("Unexpected previousExtractor type: " + previousExtractor.getClass().getSimpleName());
        }
        Extractor extractorByFileExtension = this.createExtractorByFileExtension(uri, format, muxedCaptionFormats, drmInitData, timestampAdjuster);
        extractorInput.resetPeekPosition();
        if (DefaultHlsExtractorFactory.sniffQuietly(extractorByFileExtension, extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult(extractorByFileExtension);
        }
        if (!(extractorByFileExtension instanceof WebvttExtractor) && DefaultHlsExtractorFactory.sniffQuietly(webvttExtractor = new WebvttExtractor(format.language, timestampAdjuster), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult(webvttExtractor);
        }
        if (!(extractorByFileExtension instanceof AdtsExtractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(adtsExtractor = new AdtsExtractor()), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)adtsExtractor);
        }
        if (!(extractorByFileExtension instanceof Ac3Extractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(ac3Extractor = new Ac3Extractor()), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)ac3Extractor);
        }
        if (!(extractorByFileExtension instanceof Mp3Extractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(mp3Extractor = new Mp3Extractor(0, 0L)), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)mp3Extractor);
        }
        if (!(extractorByFileExtension instanceof FragmentedMp4Extractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(fragmentedMp4Extractor = new FragmentedMp4Extractor(0, timestampAdjuster, null, drmInitData, muxedCaptionFormats != null ? muxedCaptionFormats : Collections.emptyList())), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)fragmentedMp4Extractor);
        }
        if (!(extractorByFileExtension instanceof TsExtractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(tsExtractor = DefaultHlsExtractorFactory.createTsExtractor(this.payloadReaderFactoryFlags, format, muxedCaptionFormats, timestampAdjuster)), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)tsExtractor);
        }
        return DefaultHlsExtractorFactory.buildResult(extractorByFileExtension);
    }

    private Extractor createExtractorByFileExtension(Uri uri, Format format, List<Format> muxedCaptionFormats, DrmInitData drmInitData, TimestampAdjuster timestampAdjuster) {
        String lastPathSegment = uri.getLastPathSegment();
        if (lastPathSegment == null) {
            lastPathSegment = "";
        }
        if ("text/vtt".equals(format.sampleMimeType) || lastPathSegment.endsWith(WEBVTT_FILE_EXTENSION) || lastPathSegment.endsWith(VTT_FILE_EXTENSION)) {
            return new WebvttExtractor(format.language, timestampAdjuster);
        }
        if (lastPathSegment.endsWith(AAC_FILE_EXTENSION)) {
            return new AdtsExtractor();
        }
        if (lastPathSegment.endsWith(AC3_FILE_EXTENSION) || lastPathSegment.endsWith(EC3_FILE_EXTENSION)) {
            return new Ac3Extractor();
        }
        if (lastPathSegment.endsWith(MP3_FILE_EXTENSION)) {
            return new Mp3Extractor(0, 0L);
        }
        if (lastPathSegment.endsWith(".mp4") || lastPathSegment.startsWith(M4_FILE_EXTENSION_PREFIX, lastPathSegment.length() - 4) || lastPathSegment.startsWith(".mp4", lastPathSegment.length() - 5) || lastPathSegment.startsWith(CMF_FILE_EXTENSION_PREFIX, lastPathSegment.length() - 5)) {
            return new FragmentedMp4Extractor(0, timestampAdjuster, null, drmInitData, muxedCaptionFormats != null ? muxedCaptionFormats : Collections.emptyList());
        }
        return DefaultHlsExtractorFactory.createTsExtractor(this.payloadReaderFactoryFlags, format, muxedCaptionFormats, timestampAdjuster);
    }

    private static TsExtractor createTsExtractor(int userProvidedPayloadReaderFactoryFlags, Format format, List<Format> muxedCaptionFormats, TimestampAdjuster timestampAdjuster) {
        int payloadReaderFactoryFlags = 0x10 | userProvidedPayloadReaderFactoryFlags;
        if (muxedCaptionFormats != null) {
            payloadReaderFactoryFlags |= 0x20;
        } else {
            muxedCaptionFormats = Collections.singletonList(Format.createTextSampleFormat(null, (String)"application/cea-608", (int)0, null));
        }
        String codecs = format.codecs;
        if (!TextUtils.isEmpty((CharSequence)codecs)) {
            if (!"audio/mp4a-latm".equals(MimeTypes.getAudioMediaMimeType((String)codecs))) {
                payloadReaderFactoryFlags |= 2;
            }
            if (!"video/avc".equals(MimeTypes.getVideoMediaMimeType((String)codecs))) {
                payloadReaderFactoryFlags |= 4;
            }
        }
        return new TsExtractor(2, timestampAdjuster, (TsPayloadReader.Factory)new DefaultTsPayloadReaderFactory(payloadReaderFactoryFlags, muxedCaptionFormats));
    }

    private static Pair<Extractor, Boolean> buildResult(Extractor extractor) {
        return new Pair((Object)extractor, (Object)(extractor instanceof AdtsExtractor || extractor instanceof Ac3Extractor || extractor instanceof Mp3Extractor ? 1 : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sniffQuietly(Extractor extractor, ExtractorInput input) throws InterruptedException, IOException {
        boolean result = false;
        try {
            result = extractor.sniff(input);
        }
        catch (EOFException eOFException) {
        }
        finally {
            input.resetPeekPosition();
        }
        return result;
    }
}

