/*
 * Decompiled with CFR 0.152.
 */
package contacts.ui.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import contacts.core.entities.MutableOptionsEntity;
import contacts.core.entities.NewOptions;
import contacts.core.entities.OptionsEntity;
import contacts.ui.R;
import contacts.ui.util.RingtonePickerKt;
import contacts.ui.view.OptionsViewKt;
import contacts.ui.view.ViewExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u001aJ\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001fH\u0002J\b\u0010#\u001a\u00020\u0017H\u0002J\u0012\u0010$\u001a\u00020\u00172\b\u0010%\u001a\u0004\u0018\u00010&H\u0002R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcontacts/ui/view/OptionsView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "Lcontacts/core/entities/OptionsEntity;", "data", "getData", "()Lcontacts/core/entities/OptionsEntity;", "setData", "(Lcontacts/core/entities/OptionsEntity;)V", "starredView", "Landroid/widget/ImageView;", "sendToVoicemailView", "Landroid/widget/CheckBox;", "customRingtoneView", "onActivityResult", "", "requestCode", "resultCode", "Landroid/content/Intent;", "setOptionsFieldsListeners", "setOptionFields", "setStarredView", "starred", "", "setSendToVoicemailView", "sendToVoicemail", "toggleStarred", "selectCustomRingtone", "setCustomRingtone", "customRingtone", "Landroid/net/Uri;", "ui_release"})
public final class OptionsView
extends LinearLayout {
    @NotNull
    private OptionsEntity data;
    @NotNull
    private final ImageView starredView;
    @NotNull
    private final CheckBox sendToVoicemailView;
    @NotNull
    private final ImageView customRingtoneView;

    @JvmOverloads
    public OptionsView(@NotNull Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, defStyleAttr);
        this.data = (OptionsEntity)new NewOptions(null, null, null, false, 15, null);
        this.setOrientation(0);
        this.setGravity(17);
        LinearLayout.inflate((Context)context, (int)R.layout.view_options, (ViewGroup)((ViewGroup)this));
        this.starredView = (ImageView)this.findViewById(R.id.starred);
        this.sendToVoicemailView = (CheckBox)this.findViewById(R.id.sendToVoicemail);
        this.customRingtoneView = (ImageView)this.findViewById(R.id.customRingtone);
        this.setOptionsFieldsListeners();
    }

    public /* synthetic */ OptionsView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final OptionsEntity getData() {
        return this.data;
    }

    public final void setData(@NotNull OptionsEntity value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.data = value;
        this.setOptionFields();
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        RingtonePickerKt.onRingtoneSelected(requestCode, resultCode, data, (Function1<? super Uri, Unit>)((Function1)arg_0 -> OptionsView.onActivityResult$lambda$0(this, arg_0)));
    }

    private final void setOptionsFieldsListeners() {
        this.starredView.setOnClickListener(arg_0 -> OptionsView.setOptionsFieldsListeners$lambda$1(this, arg_0));
        this.sendToVoicemailView.setOnCheckedChangeListener((arg_0, arg_1) -> OptionsView.setOptionsFieldsListeners$lambda$2(this, arg_0, arg_1));
        this.customRingtoneView.setOnClickListener(arg_0 -> OptionsView.setOptionsFieldsListeners$lambda$3(this, arg_0));
    }

    private final void setOptionFields() {
        this.setStarredView(Intrinsics.areEqual((Object)this.data.getStarred(), (Object)true));
        this.setSendToVoicemailView(Intrinsics.areEqual((Object)this.data.getSendToVoicemail(), (Object)true));
    }

    private final void setStarredView(boolean starred) {
        this.starredView.setImageResource(starred ? 17301618 : 17301619);
    }

    private final void setSendToVoicemailView(boolean sendToVoicemail) {
        this.sendToVoicemailView.setChecked(sendToVoicemail);
    }

    private final void toggleStarred() {
        boolean currentlyStarred = Intrinsics.areEqual((Object)this.data.getStarred(), (Object)true);
        OptionsViewKt.access$applyIfMutable(this.data, arg_0 -> OptionsView.toggleStarred$lambda$4(currentlyStarred, arg_0));
        this.setStarredView(!currentlyStarred);
    }

    private final void sendToVoicemail(boolean sendToVoicemail) {
        OptionsViewKt.access$applyIfMutable(this.data, arg_0 -> OptionsView.sendToVoicemail$lambda$5(sendToVoicemail, arg_0));
    }

    private final void selectCustomRingtone() {
        block0: {
            Activity activity = ViewExtensionsKt.getActivity((View)this);
            if (activity == null) break block0;
            RingtonePickerKt.selectRingtone(activity, this.data.getCustomRingtone());
        }
    }

    private final void setCustomRingtone(Uri customRingtone) {
        OptionsViewKt.access$applyIfMutable(this.data, arg_0 -> OptionsView.setCustomRingtone$lambda$6(customRingtone, arg_0));
    }

    @JvmOverloads
    public OptionsView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public OptionsView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final Unit onActivityResult$lambda$0(OptionsView this$0, Uri ringtoneUri) {
        this$0.setCustomRingtone(ringtoneUri);
        return Unit.INSTANCE;
    }

    private static final void setOptionsFieldsListeners$lambda$1(OptionsView this$0, View it) {
        this$0.toggleStarred();
    }

    private static final void setOptionsFieldsListeners$lambda$2(OptionsView this$0, CompoundButton compoundButton, boolean isChecked) {
        this$0.sendToVoicemail(isChecked);
    }

    private static final void setOptionsFieldsListeners$lambda$3(OptionsView this$0, View it) {
        this$0.selectCustomRingtone();
    }

    private static final Unit toggleStarred$lambda$4(boolean $currentlyStarred, MutableOptionsEntity $this$applyIfMutable) {
        Intrinsics.checkNotNullParameter((Object)$this$applyIfMutable, (String)"$this$applyIfMutable");
        $this$applyIfMutable.setStarred(Boolean.valueOf(!$currentlyStarred));
        return Unit.INSTANCE;
    }

    private static final Unit sendToVoicemail$lambda$5(boolean $sendToVoicemail, MutableOptionsEntity $this$applyIfMutable) {
        Intrinsics.checkNotNullParameter((Object)$this$applyIfMutable, (String)"$this$applyIfMutable");
        $this$applyIfMutable.setSendToVoicemail(Boolean.valueOf($sendToVoicemail));
        return Unit.INSTANCE;
    }

    private static final Unit setCustomRingtone$lambda$6(Uri $customRingtone, MutableOptionsEntity $this$applyIfMutable) {
        Intrinsics.checkNotNullParameter((Object)$this$applyIfMutable, (String)"$this$applyIfMutable");
        $this$applyIfMutable.setCustomRingtone($customRingtone);
        return Unit.INSTANCE;
    }
}

