/*
 * Decompiled with CFR 0.152.
 */
package contacts.ui.view;

import android.app.DatePickerDialog;
import android.content.Context;
import android.widget.DatePicker;
import contacts.core.entities.EventDate;
import contacts.core.entities.EventEntity;
import contacts.core.entities.MutableEventEntity;
import contacts.ui.R;
import contacts.ui.entities.EventTypeFactory;
import contacts.ui.view.DataEntityWithTypeAndLabelView;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J*\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcontacts/ui/view/EventView;", "Lcontacts/ui/view/DataEntityWithTypeAndLabelView;", "Lcontacts/core/entities/EventEntity$Type;", "Lcontacts/core/entities/EventEntity;", "Landroid/app/DatePickerDialog$OnDateSetListener;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "onDataFieldClicked", "", "onDateSet", "view", "Landroid/widget/DatePicker;", "year", "", "month", "dayOfMonth", "showDatePickerDialog", "ui_release"})
final class EventView
extends DataEntityWithTypeAndLabelView<EventEntity.Type, EventEntity>
implements DatePickerDialog.OnDateSetListener {
    public EventView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, null, 0, 0, R.string.contacts_ui_event_hint, false, EventTypeFactory.INSTANCE, 6, null);
    }

    @Override
    protected void onDataFieldClicked() {
        this.showDatePickerDialog();
    }

    public void onDateSet(@Nullable DatePicker view, int year, int month, int dayOfMonth) {
        EventEntity data = (EventEntity)this.getData();
        if (data != null && data instanceof MutableEventEntity) {
            ((MutableEventEntity)data).setDate(EventDate.Companion.from(Integer.valueOf(year), month, dayOfMonth));
        }
        this.setDataField();
    }

    private final void showDatePickerDialog() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int monthOfYear = calendar.get(2);
        int dayOfMonth = calendar.get(5);
        new DatePickerDialog(this.getContext(), (DatePickerDialog.OnDateSetListener)this, year, monthOfYear, dayOfMonth).show();
    }
}

