/*
 * Decompiled with CFR 0.152.
 */
package contacts.debug;

import android.content.Context;
import android.database.Cursor;
import android.provider.ContactsContract;
import contacts.debug.LogKt;
import contacts.debug.LogPermissionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"logGroupsTable", "", "Landroid/content/Context;", "debug_release"})
public final class LogGroupsTableKt {
    public static final void logGroupsTable(@NotNull Context $this$logGroupsTable) {
        Intrinsics.checkNotNullParameter((Object)$this$logGroupsTable, (String)"<this>");
        if (!LogPermissionsKt.hasReadPermission($this$logGroupsTable)) {
            LogKt.log("#### Groups table - read contacts permission not granted");
            return;
        }
        LogKt.log("#### Groups table");
        String[] stringArray = new String[]{"_id", "sourceid", "system_id", "title", "group_is_read_only", "favorites", "auto_add", "should_sync", "account_name", "account_type", "deleted"};
        Cursor cursor = $this$logGroupsTable.getContentResolver().query(ContactsContract.Groups.CONTENT_URI, stringArray, null, null, null);
        if (cursor == null) {
            return;
        }
        while (cursor.moveToNext()) {
            String id = cursor.getString(0);
            String sourceId = cursor.getString(1);
            String systemId = cursor.getString(2);
            String title = cursor.getString(3);
            String isReadOnly = cursor.getString(4);
            String favorites = cursor.getString(5);
            String autoAdd = cursor.getString(6);
            String shouldSync = cursor.getString(7);
            String accountName = cursor.getString(8);
            String accountType = cursor.getString(9);
            String deleted = cursor.getString(10);
            LogKt.log(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                Group id: " + id + ", sourceId: " + sourceId + ", systemId: " + systemId + ", title: " + title + ",\n                 isReadOnly: " + isReadOnly + ", favorites: " + favorites + ", autoAdd: " + autoAdd + ",\n                 shouldSync: " + shouldSync + ", accountName: " + accountName + ", accountType: " + accountType + ",\n                 deleted: " + deleted + "\n            ")), (String)"\n", (String)"", (boolean)false, (int)4, null));
        }
        cursor.close();
    }
}

