/*
 * Decompiled with CFR 0.152.
 */
package com.github.vertical_blank.sqlformatter;

import com.github.vertical_blank.sqlformatter.core.AbstractFormatter;
import com.github.vertical_blank.sqlformatter.core.DialectConfig;
import com.github.vertical_blank.sqlformatter.core.FormatConfig;
import com.github.vertical_blank.sqlformatter.languages.Dialect;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class SqlFormatter {
    public static String format(String query, FormatConfig cfg) {
        return SqlFormatter.standard().format(query, cfg);
    }

    public static String format(String query, String indent, List<?> params) {
        return SqlFormatter.standard().format(query, indent, params);
    }

    public static String format(String query, List<?> params) {
        return SqlFormatter.standard().format(query, params);
    }

    public static String format(String query, String indent, Map<String, ?> params) {
        return SqlFormatter.standard().format(query, indent, params);
    }

    public static String format(String query, Map<String, ?> params) {
        return SqlFormatter.standard().format(query, params);
    }

    public static String format(String query, String indent) {
        return SqlFormatter.standard().format(query, indent);
    }

    public static String format(String query) {
        return SqlFormatter.standard().format(query);
    }

    public static Formatter extend(UnaryOperator<DialectConfig> operator) {
        return SqlFormatter.standard().extend(operator);
    }

    public static Formatter standard() {
        return SqlFormatter.of(Dialect.StandardSql);
    }

    public static Formatter of(String name) {
        return Dialect.nameOf(name).map(x$0 -> new Formatter((Dialect)((Object)x$0))).orElseThrow(() -> new RuntimeException("Unsupported SQL dialect: " + name));
    }

    public static Formatter of(Dialect dialect) {
        return new Formatter(dialect);
    }

    public static class Formatter {
        private final Function<FormatConfig, AbstractFormatter> underlying;

        private Formatter(Function<FormatConfig, AbstractFormatter> underlying) {
            this.underlying = underlying;
        }

        private Formatter(Dialect dialect) {
            this(dialect.func);
        }

        public String format(String query, FormatConfig cfg) {
            return this.underlying.apply(cfg).format(query);
        }

        public String format(String query, String indent, List<?> params) {
            return this.format(query, FormatConfig.builder().indent(indent).params(params).build());
        }

        public String format(String query, List<?> params) {
            return this.format(query, FormatConfig.builder().params(params).build());
        }

        public String format(String query, String indent, Map<String, ?> params) {
            return this.format(query, FormatConfig.builder().indent(indent).params(params).build());
        }

        public String format(String query, Map<String, ?> params) {
            return this.format(query, FormatConfig.builder().params(params).build());
        }

        public String format(String query, String indent) {
            return this.format(query, FormatConfig.builder().indent(indent).build());
        }

        public String format(String query) {
            return this.format(query, FormatConfig.builder().build());
        }

        public Formatter extend(final UnaryOperator<DialectConfig> operator) {
            return new Formatter(cfg -> new AbstractFormatter((FormatConfig)cfg, (FormatConfig)cfg){
                final /* synthetic */ FormatConfig val$cfg;
                {
                    this.val$cfg = formatConfig;
                    super(cfg);
                }

                @Override
                public DialectConfig dialectConfig() {
                    return (DialectConfig)operator.apply(((AbstractFormatter)underlying.apply(this.val$cfg)).dialectConfig());
                }
            });
        }
    }
}

