/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable;

import java.awt.geom.Point2D;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.TableDrawerFunction;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;

public class RepeatedHeaderTableDrawer
extends TableDrawer {
    protected RepeatedHeaderTableDrawer(float startX, float startY, PDPageContentStream contentStream, Table table, float endY) {
        super(startX, startY, contentStream, table, endY);
    }

    @Override
    public void draw() throws IOException {
        if (this.rowToDraw > 0) {
            this.drawHeaderWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBackgroundColorAndCellContent);
            this.drawHeaderWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBorders);
            this.startY -= this.table.getRows().get(0).getHeight();
        }
        this.drawWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBackgroundColorAndCellContent, false);
        this.drawWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBorders, true);
    }

    protected void drawHeaderWithFunction(Point2D.Float startingPoint, TableDrawerFunction function) throws IOException {
        float x = startingPoint.x;
        float y = startingPoint.y;
        Row headerRow = this.table.getRows().get(0);
        int columnCounter = 0;
        y -= headerRow.getHeight();
        for (AbstractCell cell : headerRow.getCells()) {
            while (this.table.isRowSpanAt(0, columnCounter)) {
                x += this.table.getColumns().get(columnCounter).getWidth();
                ++columnCounter;
            }
            function.accept(new Point2D.Float(x, y), cell);
            x += cell.getWidth();
            columnCounter += cell.getColSpan();
        }
    }

    protected RepeatedHeaderTableDrawer(RepeatedHeaderTableDrawerBuilder<?, ?> b) {
        super(b);
    }

    public static RepeatedHeaderTableDrawerBuilder<?, ?> builder() {
        return new RepeatedHeaderTableDrawerBuilderImpl();
    }

    private static final class RepeatedHeaderTableDrawerBuilderImpl
    extends RepeatedHeaderTableDrawerBuilder<RepeatedHeaderTableDrawer, RepeatedHeaderTableDrawerBuilderImpl> {
        private RepeatedHeaderTableDrawerBuilderImpl() {
        }

        @Override
        protected RepeatedHeaderTableDrawerBuilderImpl self() {
            return this;
        }

        @Override
        public RepeatedHeaderTableDrawer build() {
            return new RepeatedHeaderTableDrawer(this);
        }
    }

    public static abstract class RepeatedHeaderTableDrawerBuilder<C extends RepeatedHeaderTableDrawer, B extends RepeatedHeaderTableDrawerBuilder<C, B>>
    extends TableDrawer.TableDrawerBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "RepeatedHeaderTableDrawer.RepeatedHeaderTableDrawerBuilder(super=" + super.toString() + ")";
        }
    }
}

