/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell;

import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.cell.TextCellDrawer;
import org.vandeseer.easytable.drawing.cell.VerticalTextCellDrawer;
import org.vandeseer.easytable.settings.Orientation;
import org.vandeseer.easytable.structure.Column;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.util.PdfUtil;

public class TextCell
extends AbstractCell {
    @NonNull
    protected String text;
    protected Color textColor;
    protected float lineSpacing;
    protected Orientation textOrientation;

    public PDFont getFont() {
        return this.settings.getFont();
    }

    public Integer getFontSize() {
        return this.settings.getFontSize();
    }

    public Color getTextColor() {
        return this.settings.getTextColor();
    }

    @Override
    protected Drawer createDefaultDrawer() {
        return this.textOrientation == Orientation.HORIZONTAL ? new TextCellDrawer(this) : new VerticalTextCellDrawer(this);
    }

    @Override
    public float getMinHeight() {
        if (this.textOrientation == Orientation.VERTICAL) {
            float widthOfThreeChars = this.getFont().getAverageFontWidth() * (float)this.getFontSize().intValue() / 1000.0f * 3.0f;
            return this.getVerticalPadding() + widthOfThreeChars > super.getMinHeight() ? this.getVerticalPadding() + widthOfThreeChars : super.getMinHeight();
        }
        return this.getVerticalPadding() + this.getTextHeight() > super.getMinHeight() ? this.getVerticalPadding() + this.getTextHeight() : super.getMinHeight();
    }

    public float getTextHeight() {
        float fontHeight = PdfUtil.getFontHeight(this.getFont(), this.getFontSize());
        if (this.settings.isWordBreak()) {
            int size = PdfUtil.getOptimalTextBreakLines(this.text, this.getFont(), this.getFontSize(), this.getWidthOfText()).size();
            float heightOfTextLines = (float)size * fontHeight;
            float heightOfLineSpacing = (float)(size - 1) * fontHeight * this.getLineSpacing();
            return heightOfTextLines + heightOfLineSpacing;
        }
        return fontHeight;
    }

    public float getWidthOfText() {
        this.assertIsRendered();
        float notBrokenTextWidth = PdfUtil.getStringWidth(this.text, this.getFont(), this.getFontSize());
        if (this.settings.isWordBreak()) {
            float maxWidth = this.getMaxWidthOfText() - this.getHorizontalPadding();
            List<String> textLines = PdfUtil.getOptimalTextBreakLines(this.text, this.getFont(), this.getFontSize(), maxWidth);
            return textLines.stream().map(line -> Float.valueOf(PdfUtil.getStringWidth(line, this.getFont(), this.getFontSize()))).max(Comparator.naturalOrder()).orElse(Float.valueOf(notBrokenTextWidth)).floatValue();
        }
        return notBrokenTextWidth;
    }

    private float getMaxWidthOfText() {
        float columnsWidth = this.getColumn().getWidth();
        if (this.getColSpan() > 1) {
            Column currentColumn = this.getColumn();
            for (int i = 1; i < this.getColSpan(); ++i) {
                columnsWidth += currentColumn.getNext().getWidth();
                currentColumn = currentColumn.getNext();
            }
        }
        return columnsWidth;
    }

    private static float $default$lineSpacing() {
        return 1.0f;
    }

    private static Orientation $default$textOrientation() {
        return Orientation.HORIZONTAL;
    }

    protected TextCell(TextCellBuilder<?, ?> b) {
        super(b);
        this.text = ((TextCellBuilder)b).text;
        if (this.text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.textColor = ((TextCellBuilder)b).textColor;
        this.lineSpacing = ((TextCellBuilder)b).lineSpacing$set ? ((TextCellBuilder)b).lineSpacing$value : TextCell.$default$lineSpacing();
        this.textOrientation = ((TextCellBuilder)b).textOrientation$set ? ((TextCellBuilder)b).textOrientation$value : TextCell.$default$textOrientation();
    }

    public static TextCellBuilder<?, ?> builder() {
        return new TextCellBuilderImpl();
    }

    public TextCellBuilder<?, ?> toBuilder() {
        return new TextCellBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public Orientation getTextOrientation() {
        return this.textOrientation;
    }

    private static final class TextCellBuilderImpl
    extends TextCellBuilder<TextCell, TextCellBuilderImpl> {
        private TextCellBuilderImpl() {
        }

        @Override
        protected TextCellBuilderImpl self() {
            return this;
        }

        @Override
        public TextCell build() {
            return new TextCell(this);
        }
    }

    public static abstract class TextCellBuilder<C extends TextCell, B extends TextCellBuilder<C, B>>
    extends AbstractCell.AbstractCellBuilder<C, B> {
        private String text;
        private Color textColor;
        private boolean lineSpacing$set;
        private float lineSpacing$value;
        private boolean textOrientation$set;
        private Orientation textOrientation$value;

        public B font(PDFont font) {
            this.settings.setFont(font);
            return (B)this.self();
        }

        public B fontSize(Integer fontSize) {
            this.settings.setFontSize(fontSize);
            return (B)this.self();
        }

        public B textColor(Color textColor) {
            this.settings.setTextColor(textColor);
            return (B)this.self();
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TextCellBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TextCell instance, TextCellBuilder<?, ?> b) {
            b.text(instance.text);
            b.textColor(instance.textColor);
            b.lineSpacing(instance.lineSpacing);
            b.textOrientation(instance.textOrientation);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return (B)this.self();
        }

        public B lineSpacing(float lineSpacing) {
            this.lineSpacing$value = lineSpacing;
            this.lineSpacing$set = true;
            return (B)this.self();
        }

        public B textOrientation(Orientation textOrientation) {
            this.textOrientation$value = textOrientation;
            this.textOrientation$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TextCell.TextCellBuilder(super=" + super.toString() + ", text=" + this.text + ", textColor=" + this.textColor + ", lineSpacing$value=" + this.lineSpacing$value + ", textOrientation$value=" + (Object)((Object)this.textOrientation$value) + ")";
        }
    }
}

