/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell;

import java.awt.Color;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.Settings;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Column;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.TableNotYetBuiltException;

public abstract class AbstractCell {
    public static final float DEFAULT_MIN_HEIGHT = 10.0f;
    private Row row;
    private Column column;
    private float width;
    protected Settings settings;
    private final int colSpan;
    private final int rowSpan;
    private final float paddingLeft;
    private final float paddingRight;
    private final float paddingTop;
    private final float paddingBottom;
    private float borderWidthTop;
    private float borderWidthLeft;
    private float borderWidthRight;
    private float borderWidthBottom;
    private float minHeight;
    protected Drawer drawer;

    public float getHorizontalPadding() {
        return this.getPaddingLeft() + this.getPaddingRight();
    }

    public float getVerticalPadding() {
        return this.getPaddingTop() + this.getPaddingBottom();
    }

    public boolean hasBorderTop() {
        return this.getBorderWidthTop() > 0.0f;
    }

    public boolean hasBorderBottom() {
        return this.getBorderWidthBottom() > 0.0f;
    }

    public boolean hasBorderLeft() {
        return this.getBorderWidthLeft() > 0.0f;
    }

    public boolean hasBorderRight() {
        return this.getBorderWidthRight() > 0.0f;
    }

    public boolean hasBackgroundColor() {
        return this.settings.getBackgroundColor() != null;
    }

    public Color getBackgroundColor() {
        return this.settings.getBackgroundColor();
    }

    public Color getBorderColor() {
        return this.settings.getBorderColor();
    }

    public boolean isWordBreak() {
        return this.settings.isWordBreak();
    }

    public float getHeight() {
        this.assertIsRendered();
        return this.getRowSpan() > 1 ? this.calculateHeightForRowSpan() : this.getMinHeight();
    }

    public Drawer getDrawer() {
        if (this.drawer != null) {
            this.drawer.setCell(this);
            return this.drawer;
        }
        return this.createDefaultDrawer();
    }

    protected abstract Drawer createDefaultDrawer();

    public float calculateHeightForRowSpan() {
        Row currentRow = this.row;
        float result = currentRow.getHeight();
        for (int i = 1; i < this.getRowSpan(); ++i) {
            result += currentRow.getNext().getHeight();
            currentRow = currentRow.getNext();
        }
        return result;
    }

    protected void assertIsRendered() {
        if (this.column == null || this.row == null) {
            throw new TableNotYetBuiltException();
        }
    }

    private static int $default$colSpan() {
        return 1;
    }

    private static int $default$rowSpan() {
        return 1;
    }

    private static float $default$paddingLeft() {
        return 4.0f;
    }

    private static float $default$paddingRight() {
        return 4.0f;
    }

    private static float $default$paddingTop() {
        return 4.0f;
    }

    private static float $default$paddingBottom() {
        return 4.0f;
    }

    private static float $default$borderWidthTop() {
        return 0.0f;
    }

    private static float $default$borderWidthLeft() {
        return 0.0f;
    }

    private static float $default$borderWidthRight() {
        return 0.0f;
    }

    private static float $default$borderWidthBottom() {
        return 0.0f;
    }

    private static float $default$minHeight() {
        return 10.0f;
    }

    protected AbstractCell(AbstractCellBuilder<?, ?> b) {
        this.row = ((AbstractCellBuilder)b).row;
        this.column = ((AbstractCellBuilder)b).column;
        this.width = ((AbstractCellBuilder)b).width;
        this.settings = b.settings;
        this.colSpan = ((AbstractCellBuilder)b).colSpan$set ? ((AbstractCellBuilder)b).colSpan$value : AbstractCell.$default$colSpan();
        this.rowSpan = ((AbstractCellBuilder)b).rowSpan$set ? ((AbstractCellBuilder)b).rowSpan$value : AbstractCell.$default$rowSpan();
        this.paddingLeft = ((AbstractCellBuilder)b).paddingLeft$set ? ((AbstractCellBuilder)b).paddingLeft$value : AbstractCell.$default$paddingLeft();
        this.paddingRight = ((AbstractCellBuilder)b).paddingRight$set ? ((AbstractCellBuilder)b).paddingRight$value : AbstractCell.$default$paddingRight();
        this.paddingTop = ((AbstractCellBuilder)b).paddingTop$set ? ((AbstractCellBuilder)b).paddingTop$value : AbstractCell.$default$paddingTop();
        this.paddingBottom = ((AbstractCellBuilder)b).paddingBottom$set ? ((AbstractCellBuilder)b).paddingBottom$value : AbstractCell.$default$paddingBottom();
        this.borderWidthTop = ((AbstractCellBuilder)b).borderWidthTop$set ? ((AbstractCellBuilder)b).borderWidthTop$value : AbstractCell.$default$borderWidthTop();
        this.borderWidthLeft = ((AbstractCellBuilder)b).borderWidthLeft$set ? ((AbstractCellBuilder)b).borderWidthLeft$value : AbstractCell.$default$borderWidthLeft();
        this.borderWidthRight = ((AbstractCellBuilder)b).borderWidthRight$set ? ((AbstractCellBuilder)b).borderWidthRight$value : AbstractCell.$default$borderWidthRight();
        this.borderWidthBottom = ((AbstractCellBuilder)b).borderWidthBottom$set ? ((AbstractCellBuilder)b).borderWidthBottom$value : AbstractCell.$default$borderWidthBottom();
        this.minHeight = ((AbstractCellBuilder)b).minHeight$set ? ((AbstractCellBuilder)b).minHeight$value : AbstractCell.$default$minHeight();
        this.drawer = ((AbstractCellBuilder)b).drawer;
    }

    public Row getRow() {
        return this.row;
    }

    public Column getColumn() {
        return this.column;
    }

    public float getWidth() {
        return this.width;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public float getBorderWidthTop() {
        return this.borderWidthTop;
    }

    public float getBorderWidthLeft() {
        return this.borderWidthLeft;
    }

    public float getBorderWidthRight() {
        return this.borderWidthRight;
    }

    public float getBorderWidthBottom() {
        return this.borderWidthBottom;
    }

    public float getMinHeight() {
        return this.minHeight;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public Settings getSettings() {
        return this.settings;
    }

    protected void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setDrawer(Drawer drawer) {
        this.drawer = drawer;
    }

    public static abstract class AbstractCellBuilder<C extends AbstractCell, B extends AbstractCellBuilder<C, B>> {
        private Row row;
        private Column column;
        private float width;
        private boolean colSpan$set;
        private int colSpan$value;
        private boolean rowSpan$set;
        private int rowSpan$value;
        private boolean paddingLeft$set;
        private float paddingLeft$value;
        private boolean paddingRight$set;
        private float paddingRight$value;
        private boolean paddingTop$set;
        private float paddingTop$value;
        private boolean paddingBottom$set;
        private float paddingBottom$value;
        private boolean borderWidthTop$set;
        private float borderWidthTop$value;
        private boolean borderWidthLeft$set;
        private float borderWidthLeft$value;
        private boolean borderWidthRight$set;
        private float borderWidthRight$value;
        private boolean borderWidthBottom$set;
        private float borderWidthBottom$value;
        private boolean minHeight$set;
        private float minHeight$value;
        private Drawer drawer;
        protected Settings settings = Settings.builder().build();

        public B borderWidth(float borderWidth) {
            return ((AbstractCellBuilder)((AbstractCellBuilder)((AbstractCellBuilder)this.borderWidthTop(borderWidth)).borderWidthBottom(borderWidth)).borderWidthLeft(borderWidth)).borderWidthRight(borderWidth);
        }

        public B padding(float padding) {
            return ((AbstractCellBuilder)((AbstractCellBuilder)((AbstractCellBuilder)this.paddingTop(padding)).paddingBottom(padding)).paddingLeft(padding)).paddingRight(padding);
        }

        public B horizontalAlignment(HorizontalAlignment alignment) {
            this.settings.setHorizontalAlignment(alignment);
            return this.self();
        }

        public B verticalAlignment(VerticalAlignment alignment) {
            this.settings.setVerticalAlignment(alignment);
            return this.self();
        }

        public B backgroundColor(Color backgroundColor) {
            this.settings.setBackgroundColor(backgroundColor);
            return this.self();
        }

        public B borderColor(Color borderColor) {
            this.settings.setBorderColor(borderColor);
            return this.self();
        }

        public B wordBreak(Boolean wordBreak) {
            this.settings.setWordBreak(wordBreak);
            return this.self();
        }

        protected B $fillValuesFrom(C instance) {
            AbstractCellBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AbstractCell instance, AbstractCellBuilder<?, ?> b) {
            b.row(instance.row);
            b.column(instance.column);
            b.width(instance.width);
            b.settings(instance.settings);
            b.colSpan(instance.colSpan);
            b.rowSpan(instance.rowSpan);
            b.paddingLeft(instance.paddingLeft);
            b.paddingRight(instance.paddingRight);
            b.paddingTop(instance.paddingTop);
            b.paddingBottom(instance.paddingBottom);
            b.borderWidthTop(instance.borderWidthTop);
            b.borderWidthLeft(instance.borderWidthLeft);
            b.borderWidthRight(instance.borderWidthRight);
            b.borderWidthBottom(instance.borderWidthBottom);
            b.minHeight(instance.minHeight);
            b.drawer(instance.drawer);
        }

        protected abstract B self();

        public abstract C build();

        public B row(Row row) {
            this.row = row;
            return this.self();
        }

        public B column(Column column) {
            this.column = column;
            return this.self();
        }

        public B width(float width) {
            this.width = width;
            return this.self();
        }

        public B settings(Settings settings) {
            this.settings = settings;
            return this.self();
        }

        public B colSpan(int colSpan) {
            this.colSpan$value = colSpan;
            this.colSpan$set = true;
            return this.self();
        }

        public B rowSpan(int rowSpan) {
            this.rowSpan$value = rowSpan;
            this.rowSpan$set = true;
            return this.self();
        }

        public B paddingLeft(float paddingLeft) {
            this.paddingLeft$value = paddingLeft;
            this.paddingLeft$set = true;
            return this.self();
        }

        public B paddingRight(float paddingRight) {
            this.paddingRight$value = paddingRight;
            this.paddingRight$set = true;
            return this.self();
        }

        public B paddingTop(float paddingTop) {
            this.paddingTop$value = paddingTop;
            this.paddingTop$set = true;
            return this.self();
        }

        public B paddingBottom(float paddingBottom) {
            this.paddingBottom$value = paddingBottom;
            this.paddingBottom$set = true;
            return this.self();
        }

        public B borderWidthTop(float borderWidthTop) {
            this.borderWidthTop$value = borderWidthTop;
            this.borderWidthTop$set = true;
            return this.self();
        }

        public B borderWidthLeft(float borderWidthLeft) {
            this.borderWidthLeft$value = borderWidthLeft;
            this.borderWidthLeft$set = true;
            return this.self();
        }

        public B borderWidthRight(float borderWidthRight) {
            this.borderWidthRight$value = borderWidthRight;
            this.borderWidthRight$set = true;
            return this.self();
        }

        public B borderWidthBottom(float borderWidthBottom) {
            this.borderWidthBottom$value = borderWidthBottom;
            this.borderWidthBottom$set = true;
            return this.self();
        }

        public B minHeight(float minHeight) {
            this.minHeight$value = minHeight;
            this.minHeight$set = true;
            return this.self();
        }

        public B drawer(Drawer drawer) {
            this.drawer = drawer;
            return this.self();
        }

        public String toString() {
            return "AbstractCell.AbstractCellBuilder(row=" + this.row + ", column=" + this.column + ", width=" + this.width + ", settings=" + this.settings + ", colSpan$value=" + this.colSpan$value + ", rowSpan$value=" + this.rowSpan$value + ", paddingLeft$value=" + this.paddingLeft$value + ", paddingRight$value=" + this.paddingRight$value + ", paddingTop$value=" + this.paddingTop$value + ", paddingBottom$value=" + this.paddingBottom$value + ", borderWidthTop$value=" + this.borderWidthTop$value + ", borderWidthLeft$value=" + this.borderWidthLeft$value + ", borderWidthRight$value=" + this.borderWidthRight$value + ", borderWidthBottom$value=" + this.borderWidthBottom$value + ", minHeight$value=" + this.minHeight$value + ", drawer=" + this.drawer + ")";
        }
    }
}

