/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing.cell;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.util.PdfUtil;

public class VerticalTextCellDrawer
implements Drawer {
    private TextCell cell;

    public VerticalTextCellDrawer() {
    }

    public VerticalTextCellDrawer(TextCell cell) {
        this.cell = cell;
    }

    @Override
    public void setCell(AbstractCell cell) {
        this.cell = (TextCell)cell;
    }

    @Override
    public void draw(DrawingContext drawingContext) throws IOException {
        float startX = drawingContext.getStartingPoint().x;
        float startY = drawingContext.getStartingPoint().y;
        PDFont currentFont = this.cell.getFont();
        int currentFontSize = this.cell.getFontSize();
        Color currentTextColor = this.cell.getTextColor();
        float yOffset = startY + this.cell.getPaddingBottom();
        float height = this.cell.getRow().getHeight();
        if (this.cell.getRowSpan() > 1) {
            float rowSpanAdaption = this.cell.calculateHeightForRowSpan() - this.cell.getRow().getHeight();
            yOffset -= rowSpanAdaption;
            height = this.cell.calculateHeightForRowSpan();
        }
        List<String> lines = this.cell.isWordBreak() ? PdfUtil.getOptimalTextBreakLines(this.cell.getText(), currentFont, currentFontSize, height - this.cell.getVerticalPadding()) : Collections.singletonList(this.cell.getText());
        float xOffset = startX + this.cell.getPaddingLeft() - PdfUtil.getFontHeight(currentFont, currentFontSize);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            this.drawText(line, currentFont, currentFontSize, currentTextColor, xOffset += PdfUtil.getFontHeight(currentFont, currentFontSize) + (i > 0 ? PdfUtil.getFontHeight(currentFont, currentFontSize) * this.cell.getLineSpacing() : 0.0f), yOffset, drawingContext.getContentStream());
        }
    }

    protected void drawText(String text, PDFont font, int fontSize, Color color, float x, float y, PDPageContentStream contentStream) throws IOException {
        AffineTransform transform = AffineTransform.getTranslateInstance(x, y);
        transform.concatenate(AffineTransform.getRotateInstance(1.5707963267948966));
        transform.concatenate(AffineTransform.getTranslateInstance(-x, -y - (float)fontSize));
        contentStream.moveTo(x, y);
        contentStream.beginText();
        contentStream.setTextMatrix(transform);
        contentStream.setNonStrokingColor(color);
        contentStream.setFont(font, (float)fontSize);
        contentStream.newLineAtOffset(x, y);
        contentStream.showText(text);
        contentStream.endText();
        contentStream.setCharacterSpacing(0.0f);
    }
}

