/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.TableDrawerFunction;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.CellBaseData;
import org.vandeseer.easytable.structure.cell.CellImage;
import org.vandeseer.easytable.structure.cell.CellText;
import org.vandeseer.easytable.util.PdfUtil;

public class TableDrawer {
    protected PDPageContentStream contentStream;
    protected final Table table;
    protected float startX;
    protected float startY;
    protected float endY;
    protected int rowToDraw = 0;
    protected boolean isFinished = false;

    protected TableDrawer(float startX, float startY, PDPageContentStream contentStream, Table table, float endY) {
        this.contentStream = contentStream;
        this.table = table;
        this.startX = startX;
        this.startY = startY - PdfUtil.getFontHeight(table.getSettings().getFont(), table.getSettings().getFontSize());
        this.endY = endY;
    }

    public void draw() throws IOException {
        this.drawWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBackgroundColorAndCellContent, false);
        this.drawWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBorders, true);
    }

    public void draw(Supplier<PDDocument> documentSupplier, Supplier<PDPage> pageSupplier, float yOffset) throws IOException {
        PDDocument document = documentSupplier.get();
        do {
            PDPage page = pageSupplier.get();
            document.addPage(page);
            try (PDPageContentStream newPageContentStream = new PDPageContentStream(document, page);){
                this.contentStream(newPageContentStream).draw();
            }
            this.startY(page.getMediaBox().getHeight() - yOffset);
        } while (!this.isFinished());
    }

    protected void drawWithFunction(Point2D.Float startingPoint, TableDrawerFunction function, boolean isLastAction) throws IOException {
        float y = startingPoint.y;
        for (int i = this.rowToDraw; i < this.table.getRows().size(); ++i) {
            Row row = this.table.getRows().get(i);
            int columnCounter = 0;
            float lowestPoint = y - row.getCells().stream().map(CellBaseData::getHeight).max(Comparator.naturalOrder()).orElse(Float.valueOf(row.getHeight())).floatValue();
            if (lowestPoint < this.endY) {
                if (isLastAction) {
                    this.rowToDraw = i;
                }
                return;
            }
            float x = startingPoint.x;
            y -= row.getHeight();
            for (CellBaseData cell : row.getCells()) {
                while (this.table.isRowSpanAt(i, columnCounter)) {
                    x += this.table.getColumns().get(columnCounter).getWidth();
                    ++columnCounter;
                }
                float cellWidth = this.table.getAvailableCellWidthRespectingSpan(columnCounter, cell.getColSpan());
                function.accept(new Point2D.Float(x, y), row, cell, cellWidth);
                x += cellWidth;
                columnCounter += cell.getColSpan();
            }
        }
        if (isLastAction) {
            this.isFinished = true;
        }
    }

    protected void drawBackgroundColorAndCellContent(Point2D.Float start, Row row, CellBaseData cell, float cellWidth) throws IOException {
        float y;
        float rowHeight = row.getHeight();
        float height = cell.getHeight() > rowHeight ? cell.getHeight() : rowHeight;
        float f = y = cell.getHeight() > rowHeight ? start.y + rowHeight - cell.getHeight() : start.y;
        if (cell.hasBackgroundColor()) {
            this.drawCellBackground(cell, start.x, y, cellWidth, height);
        }
        if (cell instanceof CellText) {
            this.drawTextCell((CellText)cell, cellWidth, start.x, start.y);
        } else if (cell instanceof CellImage) {
            this.drawImageCell((CellImage)cell, cellWidth, start.x, start.y);
        }
    }

    protected void drawBorders(Point2D.Float start, Row row, CellBaseData cell, float cellWidth) throws IOException {
        float rowHeight = row.getHeight();
        float height = cell.getHeight() > rowHeight ? cell.getHeight() : rowHeight;
        float sY = cell.getHeight() > rowHeight ? start.y + rowHeight - cell.getHeight() : start.y;
        Color cellBorderColor = cell.getBorderColor();
        Color rowBorderColor = row.getSettings().getBorderColor();
        if (cell.hasBorderTop() || cell.hasBorderBottom()) {
            float correctionLeft = cell.getBorderWidthLeft() / 2.0f;
            float correctionRight = cell.getBorderWidthRight() / 2.0f;
            if (cell.hasBorderTop()) {
                this.contentStream.moveTo(start.x - correctionLeft, start.y + rowHeight);
                this.drawLine(cellBorderColor, cell.getBorderWidthTop(), start.x + cellWidth + correctionRight, start.y + rowHeight);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
            if (cell.hasBorderBottom()) {
                this.contentStream.moveTo(start.x - correctionLeft, sY);
                this.drawLine(cellBorderColor, cell.getBorderWidthBottom(), start.x + cellWidth + correctionRight, sY);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
        }
        if (cell.hasBorderLeft() || cell.hasBorderRight()) {
            float correctionTop = cell.getBorderWidthTop() / 2.0f;
            float correctionBottom = cell.getBorderWidthBottom() / 2.0f;
            if (cell.hasBorderLeft()) {
                this.contentStream.moveTo(start.x, sY - correctionBottom);
                this.drawLine(cellBorderColor, cell.getBorderWidthLeft(), start.x, sY + height + correctionTop);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
            if (cell.hasBorderRight()) {
                this.contentStream.moveTo(start.x + cellWidth, sY - correctionBottom);
                this.drawLine(cellBorderColor, cell.getBorderWidthRight(), start.x + cellWidth, sY + height + correctionTop);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
        }
    }

    protected void drawTextCell(CellText cell, float columnWidth, float moveX, float moveY) throws IOException {
        PDFont currentFont = cell.getFont();
        int currentFontSize = cell.getFontSize();
        Color currentTextColor = cell.getTextColor();
        float maxWidth = cell.getWidthOfText();
        List<String> lines = cell.isWordBreak() ? PdfUtil.getOptimalTextBreakLines(cell.getText(), currentFont, currentFontSize, maxWidth) : Collections.singletonList(cell.getText());
        float yStartRelative = cell.getRow().getHeight() - cell.getPaddingTop();
        if (cell.getRow().getHeight() > cell.getHeight() || cell.getRowSpan() > 1) {
            if (cell.getSettings().getVerticalAlignment() == VerticalAlignment.MIDDLE) {
                float outerHeight = cell.getRowSpan() > 1 ? cell.getHeight() : cell.getRow().getHeight();
                yStartRelative = outerHeight / 2.0f + cell.getTextHeight() / 2.0f;
                if (cell.getRowSpan() > 1) {
                    float rowSpanAdaption = cell.calculateHeightForRowSpan() - cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            } else if (cell.getSettings().getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                yStartRelative = cell.getTextHeight() + cell.getPaddingBottom();
                if (cell.getRowSpan() > 1) {
                    float rowSpanAdaption = cell.calculateHeightForRowSpan() - cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            }
        }
        float yOffset = moveY + yStartRelative;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            float xOffset = moveX + cell.getPaddingLeft();
            yOffset -= PdfUtil.getFontHeight(currentFont, currentFontSize) + (i > 0 ? PdfUtil.getFontHeight(currentFont, currentFontSize) * cell.getLineSpacing() : 0.0f);
            float textWidth = PdfUtil.getStringWidth(line, currentFont, currentFontSize);
            if (cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.RIGHT) {
                xOffset = moveX + (columnWidth - (textWidth + cell.getPaddingRight()));
            } else if (cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.CENTER) {
                float diff = (columnWidth - textWidth) / 2.0f;
                xOffset = moveX + diff;
            } else if (cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.JUSTIFY) {
                float charSpacing = 0.0f;
                if (line.length() > 1) {
                    float size = PdfUtil.getStringWidth(line, cell.getFont(), cell.getFontSize());
                    float free = cell.getWidthOfText() - size;
                    if (free > 0.0f) {
                        charSpacing = free / (float)(line.length() - 1);
                    }
                }
                if (i < lines.size() - 1) {
                    this.contentStream.setCharacterSpacing(charSpacing);
                }
            }
            this.drawText(line, currentFont, currentFontSize, currentTextColor, xOffset, yOffset);
        }
    }

    protected void drawImageCell(CellImage cell, float columnWidth, float moveX, float moveY) throws IOException {
        Point2D.Float size = cell.getFitSize();
        Point2D.Float drawAt = new Point2D.Float();
        float yStartRelative = cell.getRow().getHeight() - cell.getPaddingTop();
        if (cell.getRow().getHeight() > cell.getHeight() || cell.getRowSpan() > 1) {
            if (cell.getSettings().getVerticalAlignment() == VerticalAlignment.MIDDLE) {
                float outerHeight = cell.getRowSpan() > 1 ? cell.getHeight() : cell.getRow().getHeight();
                yStartRelative = outerHeight / 2.0f + size.y / 2.0f;
                if (cell.getRowSpan() > 1) {
                    float rowSpanAdaption = cell.calculateHeightForRowSpan() - cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            } else if (cell.getSettings().getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                yStartRelative = size.y + cell.getPaddingBottom();
                if (cell.getRowSpan() > 1) {
                    float rowSpanAdaption = cell.calculateHeightForRowSpan() - cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            }
        }
        float xOffset = moveX + cell.getPaddingLeft();
        if (cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.RIGHT) {
            xOffset = moveX + (columnWidth - (size.x + cell.getPaddingRight()));
        } else if (cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.CENTER) {
            float diff = (columnWidth - size.x) / 2.0f;
            xOffset = moveX + diff;
        }
        drawAt.x = xOffset;
        drawAt.y = moveY + yStartRelative - size.y;
        this.contentStream.drawImage(cell.getImage(), drawAt.x, drawAt.y, size.x, size.y);
    }

    protected void drawLine(Color color, float width, float toX, float toY) throws IOException {
        this.contentStream.setLineWidth(width);
        this.contentStream.lineTo(toX, toY);
        this.contentStream.setStrokingColor(color);
        this.contentStream.stroke();
    }

    protected void drawCellBackground(CellBaseData cell, float startX, float startY, float width, float height) throws IOException {
        this.contentStream.setNonStrokingColor(cell.getBackgroundColor());
        this.contentStream.addRect(startX, startY, width, height);
        this.contentStream.fill();
        this.contentStream.closePath();
        this.contentStream.setNonStrokingColor(Color.BLACK);
    }

    protected void drawText(String text, PDFont font, int fontSize, Color color, float x, float y) throws IOException {
        this.contentStream.beginText();
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.setFont(font, (float)fontSize);
        this.contentStream.newLineAtOffset(x, y);
        this.contentStream.showText(text);
        this.contentStream.endText();
        this.contentStream.setCharacterSpacing(0.0f);
    }

    protected TableDrawer(TableDrawerBuilder<?, ?> b) {
        this.contentStream = ((TableDrawerBuilder)b).contentStream;
        this.table = ((TableDrawerBuilder)b).table;
        this.startX = ((TableDrawerBuilder)b).startX;
        this.startY = ((TableDrawerBuilder)b).startY;
        this.endY = ((TableDrawerBuilder)b).endY;
        this.rowToDraw = ((TableDrawerBuilder)b).rowToDraw;
        this.isFinished = ((TableDrawerBuilder)b).isFinished;
    }

    public static TableDrawerBuilder<?, ?> builder() {
        return new TableDrawerBuilderImpl();
    }

    public TableDrawerBuilder<?, ?> toBuilder() {
        return new TableDrawerBuilderImpl().$fillValuesFrom(this);
    }

    public TableDrawer contentStream(PDPageContentStream contentStream) {
        this.contentStream = contentStream;
        return this;
    }

    public TableDrawer startX(float startX) {
        this.startX = startX;
        return this;
    }

    public TableDrawer startY(float startY) {
        this.startY = startY;
        return this;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    private static final class TableDrawerBuilderImpl
    extends TableDrawerBuilder<TableDrawer, TableDrawerBuilderImpl> {
        private TableDrawerBuilderImpl() {
        }

        @Override
        protected TableDrawerBuilderImpl self() {
            return this;
        }

        @Override
        public TableDrawer build() {
            return new TableDrawer(this);
        }
    }

    public static abstract class TableDrawerBuilder<C extends TableDrawer, B extends TableDrawerBuilder<C, B>> {
        private PDPageContentStream contentStream;
        private Table table;
        private float startX;
        private float startY;
        private float endY;
        private int rowToDraw;
        private boolean isFinished;

        protected B $fillValuesFrom(C instance) {
            TableDrawerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TableDrawer instance, TableDrawerBuilder<?, ?> b) {
            b.contentStream(instance.contentStream);
            b.table(instance.table);
            b.startX(instance.startX);
            b.startY(instance.startY);
            b.endY(instance.endY);
            b.rowToDraw(instance.rowToDraw);
            b.isFinished(instance.isFinished);
        }

        protected abstract B self();

        public abstract C build();

        public B contentStream(PDPageContentStream contentStream) {
            this.contentStream = contentStream;
            return this.self();
        }

        public B table(Table table) {
            this.table = table;
            return this.self();
        }

        public B startX(float startX) {
            this.startX = startX;
            return this.self();
        }

        public B startY(float startY) {
            this.startY = startY;
            return this.self();
        }

        public B endY(float endY) {
            this.endY = endY;
            return this.self();
        }

        public B rowToDraw(int rowToDraw) {
            this.rowToDraw = rowToDraw;
            return this.self();
        }

        public B isFinished(boolean isFinished) {
            this.isFinished = isFinished;
            return this.self();
        }

        public String toString() {
            return "TableDrawer.TableDrawerBuilder(contentStream=" + this.contentStream + ", table=" + this.table + ", startX=" + this.startX + ", startY=" + this.startY + ", endY=" + this.endY + ", rowToDraw=" + this.rowToDraw + ", isFinished=" + this.isFinished + ")";
        }
    }
}

