/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.Settings;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Column;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.cell.CellBaseData;

public class Table {
    private static final PDFont DEFAULT_FONT = PDType1Font.HELVETICA;
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    private static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    private static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGNMENT = HorizontalAlignment.LEFT;
    private static final VerticalAlignment DEFAULT_VERTICAL_ALIGNMENT = VerticalAlignment.MIDDLE;
    private final List<Row> rows;
    private final List<Column> columns;
    private Settings settings;
    private int numberOfColumns;
    private float width;
    private float borderWidth;

    public float getHeight() {
        float height = 0.0f;
        for (Row row : this.rows) {
            height += row.getHeight();
        }
        return height;
    }

    public float getAvailableCellWidthRespectingSpan(int columnIndex, int span) {
        float cellWidth = 0.0f;
        for (int i = 0; i < span; ++i) {
            cellWidth += this.getColumns().get(columnIndex + i).getWidth();
        }
        return cellWidth;
    }

    private static float $default$borderWidth() {
        return 0.2f;
    }

    public static TableBuilder builder() {
        return new TableBuilder();
    }

    public Table(List<Row> rows, List<Column> columns, Settings settings, int numberOfColumns, float width, float borderWidth) {
        this.rows = rows;
        this.columns = columns;
        this.settings = settings;
        this.numberOfColumns = numberOfColumns;
        this.width = width;
        this.borderWidth = borderWidth;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public float getWidth() {
        return this.width;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    private void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    private void setWidth(float width) {
        this.width = width;
    }

    private void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Settings getSettings() {
        return this.settings;
    }

    static /* synthetic */ Color access$000() {
        return DEFAULT_BORDER_COLOR;
    }

    static /* synthetic */ Color access$100() {
        return DEFAULT_TEXT_COLOR;
    }

    static /* synthetic */ PDFont access$200() {
        return DEFAULT_FONT;
    }

    public static class TableBuilder {
        private int numberOfColumns;
        private float width;
        private boolean borderWidth$set;
        private float borderWidth;
        private List<Row> rows = new LinkedList<Row>();
        private List<Column> columns = new LinkedList<Column>();
        private Settings settings = Settings.builder().font(Table.access$200()).fontSize(12).textColor(Table.access$100()).borderColor(Table.access$000()).wordBreak(true).build();

        private TableBuilder() {
        }

        public TableBuilder addRow(Row row) {
            if (row.getCells().stream().mapToInt(CellBaseData::getSpan).sum() != this.numberOfColumns) {
                throw new IllegalArgumentException("Number of row cells does not match with number of table columns");
            }
            this.rows.add(row);
            return this;
        }

        public TableBuilder addColumnsOfWidth(float ... columnWidths) {
            for (float columnWidth : columnWidths) {
                this.addColumnOfWidth(columnWidth);
            }
            return this;
        }

        public TableBuilder addColumnOfWidth(float width) {
            Column column = new Column(width);
            ++this.numberOfColumns;
            this.columns.add(column);
            this.width += column.getWidth();
            return this;
        }

        public TableBuilder font(PDFont font) {
            this.settings.setFont(font);
            return this;
        }

        public TableBuilder fontSize(Integer fontSize) {
            this.settings.setFontSize(fontSize);
            return this;
        }

        public TableBuilder textColor(Color textColor) {
            this.settings.setTextColor(textColor);
            return this;
        }

        public TableBuilder backgroundColor(Color backgroundColor) {
            this.settings.setBackgroundColor(backgroundColor);
            return this;
        }

        public TableBuilder borderColor(Color borderColor) {
            this.settings.setBorderColor(borderColor);
            return this;
        }

        public TableBuilder horizontalAlignment(HorizontalAlignment alignment) {
            this.settings.setHorizontalAlignment(alignment);
            return this;
        }

        public TableBuilder verticalAlignment(VerticalAlignment alignment) {
            this.settings.setVerticalAlignment(alignment);
            return this;
        }

        public TableBuilder wordBreak(Boolean wordBreak) {
            this.settings.setWordBreak(wordBreak);
            return this;
        }

        public Table build() {
            Table table = this.internalBuild();
            table.setWidth(this.width);
            table.setNumberOfColumns(this.numberOfColumns);
            for (Row row : this.rows) {
                row.setTable(table);
                row.getSettings().fillingMergeBy(table.getSettings());
                int columnNumber = 0;
                for (CellBaseData cell : row.getCells()) {
                    cell.getSettings().fillingMergeBy(row.getSettings());
                    cell.setRow(row);
                    Column column = table.getColumns().get(columnNumber);
                    cell.setColumn(column);
                    columnNumber += cell.getSpan();
                }
            }
            for (int i = 0; i < table.getColumns().size(); ++i) {
                Column column = table.getColumns().get(i);
                column.setTable(table);
                if (i >= table.getColumns().size() - 1) continue;
                column.setNext(table.getColumns().get(i + 1));
            }
            return table;
        }

        public TableBuilder rows(List<Row> rows) {
            this.rows = rows;
            return this;
        }

        public TableBuilder columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public TableBuilder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public TableBuilder numberOfColumns(int numberOfColumns) {
            this.numberOfColumns = numberOfColumns;
            return this;
        }

        public TableBuilder width(float width) {
            this.width = width;
            return this;
        }

        public TableBuilder borderWidth(float borderWidth) {
            this.borderWidth = borderWidth;
            this.borderWidth$set = true;
            return this;
        }

        public Table internalBuild() {
            float borderWidth = this.borderWidth;
            if (!this.borderWidth$set) {
                borderWidth = Table.$default$borderWidth();
            }
            return new Table(this.rows, this.columns, this.settings, this.numberOfColumns, this.width, borderWidth);
        }

        public String toString() {
            return "Table.TableBuilder(rows=" + this.rows + ", columns=" + this.columns + ", settings=" + this.settings + ", numberOfColumns=" + this.numberOfColumns + ", width=" + this.width + ", borderWidth=" + this.borderWidth + ")";
        }
    }
}

