/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.ppm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.imageio.ppm.PpmImageReader;

public class PpmImageReaderSpi
extends ImageReaderSpi {
    private static final String VendorName = "http://www.vavisoft.com";
    private static final String Version = "0.00";
    private static final String ReaderClassName = "vavi.imageio.ppm.PpmImageReader";
    private static final String[] Names = new String[]{"PPM"};
    private static final String[] Suffixes = new String[]{"ppm"};
    private static final String[] mimeTypes = new String[]{"image/x-ppm", "image/x-pnm"};
    static final String[] WriterSpiNames = new String[0];
    private static final boolean SupportsStandardStreamMetadataFormat = false;
    private static final String NativeStreamMetadataFormatName = null;
    private static final String NativeStreamMetadataFormatClassName = null;
    private static final String[] ExtraStreamMetadataFormatNames = null;
    private static final String[] ExtraStreamMetadataFormatClassNames = null;
    private static final boolean SupportsStandardImageMetadataFormat = false;
    private static final String NativeImageMetadataFormatName = "ppm";
    private static final String NativeImageMetadataFormatClassName = null;
    private static final String[] ExtraImageMetadataFormatNames = null;
    private static final String[] ExtraImageMetadataFormatClassNames = null;

    public PpmImageReaderSpi() {
        super(VendorName, Version, Names, Suffixes, mimeTypes, ReaderClassName, new Class[]{ImageInputStream.class, InputStream.class}, WriterSpiNames, false, NativeStreamMetadataFormatName, NativeStreamMetadataFormatClassName, ExtraStreamMetadataFormatNames, ExtraStreamMetadataFormatClassNames, false, NativeImageMetadataFormatName, NativeImageMetadataFormatClassName, ExtraImageMetadataFormatNames, ExtraImageMetadataFormatClassNames);
    }

    @Override
    public String getDescription(Locale locale) {
        return "PPM Image";
    }

    @Override
    public boolean canDecodeInput(Object obj) throws IOException {
        if (obj instanceof ImageInputStream) {
            ImageInputStream imageinputstream = (ImageInputStream)obj;
            byte[] bytes = new byte[4];
            try {
                imageinputstream.mark();
                imageinputstream.readFully(bytes);
                imageinputstream.reset();
            }
            catch (IOException e) {
                return false;
            }
            return bytes[0] == 80 && bytes[1] == 54 && bytes[2] == 10;
        }
        return false;
    }

    @Override
    public ImageReader createReaderInstance(Object obj) {
        return new PpmImageReader(this);
    }
}

