/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.pic;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.imageio.pic.PicImageReader;
import vavi.util.Debug;

public class PicImageReaderSpi
extends ImageReaderSpi {
    private static final String VendorName = "http://www.vavi.com";
    private static final String Version = "1.0.11";
    private static final String ReaderClassName = "vavi.imageio.mag.PicImageReader";
    private static final String[] Names = new String[]{"PIC", "pic"};
    private static final String[] Suffixes = new String[]{"pic", "PIC"};
    private static final String[] mimeTypes = new String[]{"image/x-pic"};
    static final String[] WriterSpiNames = new String[0];
    private static final boolean SupportsStandardStreamMetadataFormat = false;
    private static final String NativeStreamMetadataFormatName = null;
    private static final String NativeStreamMetadataFormatClassName = null;
    private static final String[] ExtraStreamMetadataFormatNames = null;
    private static final String[] ExtraStreamMetadataFormatClassNames = null;
    private static final boolean SupportsStandardImageMetadataFormat = false;
    private static final String NativeImageMetadataFormatName = "pic";
    private static final String NativeImageMetadataFormatClassName = null;
    private static final String[] ExtraImageMetadataFormatNames = null;
    private static final String[] ExtraImageMetadataFormatClassNames = null;

    public PicImageReaderSpi() {
        super(VendorName, Version, Names, Suffixes, mimeTypes, ReaderClassName, new Class[]{ImageInputStream.class, InputStream.class}, WriterSpiNames, false, NativeStreamMetadataFormatName, NativeStreamMetadataFormatClassName, ExtraStreamMetadataFormatNames, ExtraStreamMetadataFormatClassNames, false, NativeImageMetadataFormatName, NativeImageMetadataFormatClassName, ExtraImageMetadataFormatNames, ExtraImageMetadataFormatClassNames);
    }

    @Override
    public String getDescription(Locale locale) {
        return "PIC Yanagisawa Image";
    }

    @Override
    public boolean canDecodeInput(Object obj) throws IOException {
        byte[] header = "PIC".getBytes();
        if (obj instanceof ImageInputStream) {
            ImageInputStream is = (ImageInputStream)obj;
            byte[] bytes = new byte[header.length];
            try {
                is.mark();
                is.readFully(bytes);
                is.reset();
            }
            catch (IOException e) {
                Debug.println((Object)e);
                return false;
            }
            return Arrays.equals(header, bytes);
        }
        Debug.println((Level)Level.FINE, (Object)obj);
        return false;
    }

    @Override
    public ImageReader createReaderInstance(Object obj) {
        return new PicImageReader(this);
    }
}

