/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.logging.Level;
import javax.imageio.stream.ImageInputStream;
import vavi.io.SeekableDataInput;
import vavi.util.Debug;

public class SeekableDataInputImageInputStream
implements SeekableDataInput<ImageInputStream> {
    private ImageInputStream iis;

    public SeekableDataInputImageInputStream(ImageInputStream iis, ByteOrder byteOrder) {
        this.iis = iis;
        this.iis.setByteOrder(byteOrder);
        this.iis.mark();
    }

    public ImageInputStream origin() {
        return this.iis;
    }

    public void readFully(byte[] b) throws IOException {
        this.iis.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int r = this.iis.read(b, off, len);
        if (r < 0) {
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        return this.iis.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.iis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.iis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.iis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.iis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.iis.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.iis.readChar();
    }

    public int readInt() throws IOException {
        return this.iis.readInt();
    }

    public long readLong() throws IOException {
        return this.iis.readLong();
    }

    public float readFloat() throws IOException {
        return this.iis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.iis.readDouble();
    }

    public String readLine() throws IOException {
        return this.iis.readLine();
    }

    public String readUTF() throws IOException {
        return this.iis.readUTF();
    }

    public void position(long l) throws IOException {
        this.iis.reset();
        this.iis.seek(l);
        Debug.printf((Level)Level.FINER, (String)"%d, %d", (Object[])new Object[]{l, this.position()});
    }

    public long position() throws IOException {
        return this.iis.getStreamPosition();
    }
}

