/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ImageConverter {
    private static ImageConverter instance = new ImageConverter();
    private int cmType = 6;
    private ImageObserver imageObserver = (img, infoflags, x, y, width, height) -> (infoflags & 0x20) != 32;

    private ImageConverter() {
    }

    public static ImageConverter getInstance() {
        return instance;
    }

    public void setColorModelType(int cmType) {
        this.cmType = cmType;
    }

    public BufferedImage toBufferedImage(Image image) {
        int w = image.getWidth(this.imageObserver);
        int h = image.getHeight(this.imageObserver);
        BufferedImage bi = new BufferedImage(w, h, this.cmType);
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, this.imageObserver);
        return bi;
    }
}

