/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.resample;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.geometry.Resample;
import net.sourceforge.jiu.gui.awt.RGBA;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;
import vavi.awt.image.BasicBufferedImageOp;

public class Lanczos3ResampleOp
extends BasicBufferedImageOp {
    private double sx;
    private double sy;

    public Lanczos3ResampleOp(double sx, double sy) {
        this.sx = sx;
        this.sy = sy;
    }

    @Override
    protected int[] filterPixels(int width, int height, int[] inPixels) {
        MemoryRGB24Image inImage = new MemoryRGB24Image(width, height);
        int offset = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = inPixels[offset++] & 0xFFFFFF;
                inImage.putSample(0, x, y, pixel >> 16);
                inImage.putSample(1, x, y, pixel >> 8 & 0xFF);
                inImage.putSample(2, x, y, pixel & 0xFF);
            }
        }
        int destWidth = (int)((double)width * this.sx);
        int destHeight = (int)((double)height * this.sy);
        Resample resample = new Resample();
        try {
            resample.setInputImage((PixelImage)inImage);
            resample.setSize(destWidth, destHeight);
            resample.setFilter(5);
            resample.process();
        }
        catch (MissingParameterException | WrongParameterException e) {
            throw new IllegalStateException(e);
        }
        RGB24Image outImage = (RGB24Image)resample.getOutputImage();
        int[] outPixels = new int[destWidth * destHeight];
        byte[] red = new byte[destWidth];
        byte[] green = new byte[destWidth];
        byte[] blue = new byte[destWidth];
        int destOffset = 0;
        for (int y = 0; y < destHeight; ++y) {
            outImage.getByteSamples(0, 0, y, destWidth, 1, red, 0);
            outImage.getByteSamples(1, 0, y, destWidth, 1, green, 0);
            outImage.getByteSamples(2, 0, y, destWidth, 1, blue, 0);
            RGBA.convertFromRGB24((byte[])red, (int)0, (byte[])green, (int)0, (byte[])blue, (int)0, (int)-16777216, (int[])outPixels, (int)destOffset, (int)destWidth);
            destOffset += destWidth;
        }
        return outPixels;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, (int)((double)src.getWidth() * this.sx), (int)((double)src.getHeight() * this.sy));
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Double();
        }
        dstPt.setLocation(srcPt.getX() * this.sx, srcPt.getY() * this.sy);
        return dstPt;
    }
}

