/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.bmp;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import vavi.awt.image.bmp.WindowsBitmap;

public class WindowsBitmapImageSource
implements ImageProducer {
    private WindowsBitmap bitmap;
    private ImageConsumer ic;

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        this.ic = ic;
        if (this.ic != null) {
            this.loadPixel();
        }
        this.ic = null;
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return ic == this.ic;
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        if (this.ic == ic) {
            this.ic = null;
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public WindowsBitmapImageSource(WindowsBitmap bitmap) {
        this.bitmap = bitmap;
    }

    public WindowsBitmapImageSource(InputStream in) throws IOException {
        this.bitmap = WindowsBitmap.readFrom(in);
    }

    public WindowsBitmap getWindowsBitmap() {
        return this.bitmap;
    }

    private void loadPixel() {
        ColorModel cm = this.bitmap.getColorModel();
        int width = this.bitmap.getWidth();
        int height = this.bitmap.getHeight();
        int bits = this.bitmap.getBits();
        int compression = this.bitmap.getCompression();
        this.ic.setDimensions(width, height);
        this.ic.setProperties(new Hashtable());
        this.ic.setColorModel(cm);
        this.ic.setHints(30);
        byte[] vram = null;
        int[] ivram = null;
        switch (bits) {
            case 1: {
                vram = this.bitmap.getMonoColorData();
                break;
            }
            case 4: {
                if (compression == WindowsBitmap.Type.RLE4.ordinal()) {
                    vram = this.bitmap.get16ColorRleData();
                    break;
                }
                vram = this.bitmap.get16ColorData();
                break;
            }
            case 8: {
                if (compression == WindowsBitmap.Type.RLE8.ordinal()) {
                    vram = this.bitmap.get256ColorRleData();
                    break;
                }
                vram = this.bitmap.get256ColorData();
                break;
            }
            case 24: {
                ivram = this.bitmap.get24BitColorData();
                break;
            }
            case 32: {
                ivram = this.bitmap.get32BitColorData();
            }
        }
        if (bits == 24 || bits == 32) {
            this.ic.setPixels(0, 0, width, height, cm, ivram, 0, width);
        } else {
            this.ic.setPixels(0, 0, width, height, cm, vram, 0, width);
        }
        this.ic.imageComplete(3);
    }
}

