/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.mojo;

import com.ulisesbocchio.jasyptmavenplugin.encrypt.EncryptionService;
import com.ulisesbocchio.jasyptmavenplugin.mojo.AbstractFileJasyptMojo;
import com.ulisesbocchio.jasyptmavenplugin.mojo.FileService;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="decrypt", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class DecryptMojo
extends AbstractFileJasyptMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecryptMojo.class);

    @Override
    protected void run(EncryptionService service, Path path, String encryptPrefix, String encryptSuffix, String decryptPrefix, String decryptSuffix) throws MojoExecutionException {
        log.info("Decrypting file " + String.valueOf(path));
        try {
            String contents = FileService.read(path);
            String decryptedContents = service.decrypt(contents, encryptPrefix, encryptSuffix, decryptPrefix, decryptSuffix);
            log.info("\n" + decryptedContents);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error Decrypting: " + e.getMessage(), e);
        }
    }
}

