/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.mojo;

import com.ulisesbocchio.jasyptmavenplugin.encrypt.EncryptionService;
import com.ulisesbocchio.jasyptmavenplugin.mojo.AbstractFileJasyptMojo;
import com.ulisesbocchio.jasyptmavenplugin.mojo.FileService;
import com.ulisesbocchio.jasyptspringboot.configuration.StringEncryptorBuilder;
import com.ulisesbocchio.jasyptspringboot.properties.JasyptEncryptorConfigurationProperties;
import java.nio.file.Path;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReencryptMojo
extends AbstractFileJasyptMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractReencryptMojo.class);

    @Override
    protected void run(EncryptionService newService, Path path, String encryptPrefix, String encryptSuffix, String decryptPrefix, String decryptSuffix) throws MojoExecutionException {
        String decryptedContents = this.decrypt(path, encryptPrefix, encryptSuffix, decryptPrefix, decryptSuffix);
        log.info("Re-encrypting file " + String.valueOf(path));
        try {
            String encryptedContents = newService.encrypt(decryptedContents, encryptPrefix, encryptSuffix, decryptPrefix, decryptSuffix);
            FileService.write(path, encryptedContents);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error Re-encrypting: " + e.getMessage(), e);
        }
    }

    private String decrypt(Path path, String encryptPrefix, String encryptSuffix, String decryptPrefix, String decryptSuffix) throws MojoExecutionException {
        log.info("Decrypting file " + String.valueOf(path));
        try {
            String contents = FileService.read(path);
            return this.getOldEncryptionService().decrypt(contents, encryptPrefix, encryptSuffix, decryptPrefix, decryptSuffix);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error Decrypting: " + e.getMessage(), e);
        }
    }

    private EncryptionService getOldEncryptionService() {
        JasyptEncryptorConfigurationProperties properties = new JasyptEncryptorConfigurationProperties();
        this.configure(properties);
        StringEncryptor encryptor = new StringEncryptorBuilder(properties, "jasypt.plugin.old").build();
        return new EncryptionService(encryptor);
    }

    protected abstract void configure(JasyptEncryptorConfigurationProperties var1);

    protected <T> void setIfNotNull(Consumer<T> setter, T value) {
        if (value != null) {
            setter.accept(value);
        }
    }
}

