/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.encrypt;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.EncryptableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptionService.class);
    private final StringEncryptor encryptor;
    private final Pattern reCharsREP;

    public EncryptionService(StringEncryptor encryptor) {
        this.encryptor = encryptor;
        String regExSpecialChars = "<([{\\^-=$!|]})?*+.>";
        String regExSpecialCharsRE = regExSpecialChars.replaceAll(".", "\\\\$0");
        this.reCharsREP = Pattern.compile("[" + regExSpecialCharsRE + "]");
    }

    private String quoteRegExSpecialChars(String s) {
        Matcher m = this.reCharsREP.matcher(s);
        return m.replaceAll("\\\\$0");
    }

    private String replaceAll(String templateText, String sourcePrefix, String sourceSuffix, String targetPrefix, String targetSuffix, Function<String, String> mutator) {
        String regex = this.quoteRegExSpecialChars(sourcePrefix) + "(.*?)" + this.quoteRegExSpecialChars(sourceSuffix);
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(templateText);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String matched = matcher.group(1);
            String replacement = targetPrefix + mutator.apply(matched) + targetSuffix;
            log.debug("Converting value {} to {}", (Object)matched, (Object)replacement);
            matcher.appendReplacement(result, "");
            result.append(replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public String decrypt(String input, String encryptPrefix, String encryptSuffix, String decryptPrefix, String decryptSuffix) {
        return this.replaceAll(input, encryptPrefix, encryptSuffix, decryptPrefix, decryptSuffix, arg_0 -> ((StringEncryptor)this.encryptor).decrypt(arg_0));
    }

    public String decryptValue(String value) {
        return this.encryptor.decrypt(value);
    }

    public String encrypt(String input, String encryptPrefix, String encryptSuffix, String decryptPrefix, String decryptSuffix) {
        return this.replaceAll(input, decryptPrefix, decryptSuffix, encryptPrefix, encryptSuffix, arg_0 -> ((StringEncryptor)this.encryptor).encrypt(arg_0));
    }

    public String encryptValue(String value) {
        return this.encryptor.encrypt(value);
    }

    public EncryptableProperties getEncryptableProperties() {
        return new EncryptableProperties(this.encryptor);
    }
}

