/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr.extras;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import com.tylersuehr.esr.extras.AbstractContentLoadingState;

class ListContentLoadingState
extends AbstractContentLoadingState {
    private final int small;
    private final int large;
    private int circleSize;
    private int lineHeight;

    ListContentLoadingState(Context c) {
        super(c);
        DisplayMetrics dm = c.getResources().getDisplayMetrics();
        this.small = (int)(8.0f * dm.density);
        this.large = (int)(16.0f * dm.density);
        this.circleSize = (int)(40.0f * dm.density);
        this.lineHeight = (int)(12.0f * dm.density);
    }

    @Override
    protected void onSetupContentPaint(@NonNull Context c, @NonNull Paint contentPaint) {
        contentPaint.setColor(-7829368);
    }

    @Override
    protected void renderContent(int numberOfContentItems, int availableWidth, int availableHeight, Canvas canvas, Paint contentPaint) {
        int radius = this.circleSize >> 1;
        int verticalDistance = this.sizeOfContentItem();
        float dx = 0.0f;
        float dy = 0.0f;
        for (int i = 0; i < numberOfContentItems; ++i) {
            dx = radius + this.large;
            dy = i * verticalDistance + radius + this.large;
            canvas.drawCircle(dx, dy, (float)radius, contentPaint);
            int diff = this.circleSize - (this.lineHeight * 2 + this.small) >> 1;
            canvas.drawRect(dx += (float)(radius + this.large), dy -= (float)(radius - diff), dx + ((float)availableWidth - dx - (float)(this.large << 1)), dy + (float)this.lineHeight, contentPaint);
            canvas.drawRect(dx, dy += (float)(this.lineHeight + this.small), dx + ((float)availableWidth - dx - (float)(this.large << 3)), dy + (float)this.lineHeight, contentPaint);
        }
    }

    @Override
    protected int sizeOfContentItem() {
        return this.circleSize + this.large;
    }
}

