/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr.extras;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import com.tylersuehr.esr.extras.AbstractContentLoadingState;

class DocContentLoadingState
extends AbstractContentLoadingState {
    private final int large;
    private int lineHeight;

    DocContentLoadingState(Context c) {
        super(c);
        DisplayMetrics dm = c.getResources().getDisplayMetrics();
        this.large = (int)(16.0f * dm.density);
        this.lineHeight = (int)(12.0f * dm.density);
    }

    @Override
    protected void onSetupContentPaint(@NonNull Context c, @NonNull Paint contentPaint) {
        contentPaint.setColor(-7829368);
    }

    @Override
    protected void renderContent(int numberOfContentItems, int availableWidth, int availableHeight, Canvas canvas, Paint contentPaint) {
        float dy = 0.0f;
        int lineWidth = availableWidth - this.large;
        int itemsToDraw = availableHeight / (this.lineHeight + this.large) / 2;
        for (int i = 0; i < itemsToDraw; ++i) {
            canvas.drawRect((float)this.large, dy += (float)this.large, (float)lineWidth, dy + (float)this.lineHeight, contentPaint);
            dy += (float)this.lineHeight;
        }
        canvas.drawRect((float)this.large, dy += (float)this.large, (float)(lineWidth - lineWidth / 4), dy + (float)this.lineHeight, contentPaint);
    }

    @Override
    protected int sizeOfContentItem() {
        return this.lineHeight;
    }
}

