/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr.extras;

import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import com.tylersuehr.esr.EmptyStateRecyclerView;

public abstract class AbstractContentLoadingState
implements EmptyStateRecyclerView.StateDisplay {
    private static final int DEFAULT_ANIM_DURATION = 900;
    private final Paint contentPaint = new Paint(1);
    private boolean animateContentItems = true;
    private int numberOfContentItems = 3;
    private ValueAnimator anim;

    AbstractContentLoadingState(Context c) {
        this.onSetupContentPaint(c, this.contentPaint);
    }

    @Override
    public final void onDrawState(final EmptyStateRecyclerView rv, Canvas canvas) {
        int width = rv.getMeasuredWidth();
        int height = rv.getMeasuredHeight();
        this.renderContent(this.numberOfContentItems, width, height, canvas, this.contentPaint);
        if (this.animateContentItems && this.anim == null) {
            this.anim = ObjectAnimator.ofObject((Object)this.contentPaint, (String)"color", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{Color.parseColor((String)"#E0E0E0"), Color.parseColor((String)"#BDBDBD"), Color.parseColor((String)"#9E9E9E")});
            this.onInterceptAnimatorCreation(this.anim);
            this.anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    rv.invalidate();
                }
            });
            this.anim.start();
        }
    }

    protected void onInterceptAnimatorCreation(@NonNull ValueAnimator anim) {
        anim.setDuration(900L);
        anim.setRepeatMode(2);
        anim.setRepeatCount(-1);
    }

    protected abstract void onSetupContentPaint(@NonNull Context var1, @NonNull Paint var2);

    protected abstract void renderContent(int var1, int var2, int var3, Canvas var4, Paint var5);

    protected abstract int sizeOfContentItem();

    public void setAnimateContentItems(boolean animateContentItems) {
        this.animateContentItems = animateContentItems;
    }

    public void setNumberOfContentItems(int numberOfContentItems) {
        this.numberOfContentItems = numberOfContentItems;
    }
}

