/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.view.Gravity;
import android.view.View;
import com.tylersuehr.esr.AbstractStateDisplay;
import com.tylersuehr.esr.EmptyStateRecyclerView;

public class ImageStateDisplay
extends AbstractStateDisplay {
    public static final byte NONE = 0;
    public static final byte FIT_XY = 1;
    public static final byte FIT_WIDTH = 2;
    public static final byte FIT_HEIGHT = 3;
    public static final byte CROP_TO_WIDTH = 4;
    public static final byte CROP_TO_HEIGHT = 5;
    public static final byte CROP_XY = 6;
    private boolean imageConfigured = false;
    private byte scaleType = 0;
    private int imageGravity;
    private Bitmap image;

    @Override
    public void onDrawState(EmptyStateRecyclerView rv, Canvas canvas) {
        int width = rv.getMeasuredWidth();
        int height = rv.getMeasuredHeight();
        this.configureImage(width, height);
        int horizontalGravity = Gravity.getAbsoluteGravity((int)this.imageGravity, (int)ViewCompat.getLayoutDirection((View)rv)) & 7;
        int verticalGravity = this.imageGravity & 0x70;
        switch (horizontalGravity) {
            case 1: {
                float dx = (width >> 1) - (this.image.getWidth() >> 1);
                break;
            }
            case 0x800005: {
                float dx = width - this.image.getWidth();
                break;
            }
            default: {
                float dx = 0.0f;
            }
        }
        switch (verticalGravity) {
            case 16: {
                float dy = (height >> 1) - (this.image.getHeight() >> 1);
                break;
            }
            case 80: {
                float dy = height - this.image.getHeight();
                break;
            }
            default: {
                float dy = 0.0f;
            }
        }
        dx -= (float)this.getPaddingLeft();
        dy += (float)this.getPaddingTop();
        canvas.drawBitmap(this.image, dx += (float)this.getPaddingRight(), dy -= (float)this.getPaddingBottom(), null);
    }

    public void setScaleType(byte scaleType) {
        this.scaleType = scaleType;
        this.invalidateImage();
    }

    public void setImageGravity(int gravity) {
        this.imageGravity = gravity;
    }

    public void setImage(Bitmap bitmap) {
        this.image = bitmap;
        this.invalidateImage();
    }

    public void setImage(Drawable drawable) {
        this.image = ImageStateDisplay.drawableToBitmap(drawable);
        this.invalidateImage();
    }

    public void setImage(Context c, @DrawableRes int res) {
        this.setImage(ContextCompat.getDrawable((Context)c, (int)res));
    }

    public void resizeImage(int width, int height) {
        if (this.image == null) {
            throw new NullPointerException("Please set an image before calling resizeImage()!");
        }
        this.image = Bitmap.createScaledBitmap((Bitmap)this.image, (int)width, (int)height, (boolean)false);
        this.invalidateImage();
    }

    protected void stretchImage(int screenWidth, int screenHeight) {
        switch (this.scaleType) {
            case 1: {
                this.image = Bitmap.createScaledBitmap((Bitmap)this.image, (int)screenWidth, (int)screenHeight, (boolean)true);
                break;
            }
            case 2: {
                this.image = Bitmap.createScaledBitmap((Bitmap)this.image, (int)screenWidth, (int)this.image.getHeight(), (boolean)true);
                break;
            }
            case 3: {
                this.image = Bitmap.createScaledBitmap((Bitmap)this.image, (int)this.image.getWidth(), (int)screenHeight, (boolean)true);
            }
        }
    }

    protected void cropImage(int screenWidth, int screenHeight) {
        float scale;
        int sourceWidth = this.image.getWidth();
        int sourceHeight = this.image.getHeight();
        float xScale = (float)screenWidth / (float)sourceWidth;
        float yScale = (float)screenHeight / (float)sourceHeight;
        switch (this.scaleType) {
            case 4: {
                scale = xScale;
                break;
            }
            case 5: {
                scale = yScale;
                break;
            }
            default: {
                scale = Math.max(xScale, yScale);
            }
        }
        float scaledWidth = scale * (float)sourceWidth;
        float scaledHeight = scale * (float)sourceHeight;
        float left = ((float)screenWidth - scaledWidth) / 2.0f;
        float top = ((float)screenHeight - scaledHeight) / 2.0f;
        RectF targetRect = new RectF(left, top, left + scaledWidth, top + scaledHeight);
        Bitmap dest = Bitmap.createBitmap((int)screenWidth, (int)screenHeight, (Bitmap.Config)this.image.getConfig());
        Canvas canvas = new Canvas(dest);
        canvas.drawBitmap(this.image, null, targetRect, null);
        this.image = dest;
    }

    protected static Bitmap drawableToBitmap(Drawable dr) {
        BitmapDrawable bpDr;
        if (dr instanceof BitmapDrawable && (bpDr = (BitmapDrawable)dr).getBitmap() != null) {
            return bpDr.getBitmap();
        }
        Bitmap bitmap = dr.getIntrinsicWidth() <= 0 || dr.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)dr.getIntrinsicWidth(), (int)dr.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        dr.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        dr.draw(canvas);
        return bitmap;
    }

    private void invalidateImage() {
        this.imageConfigured = false;
    }

    private void configureImage(int width, int height) {
        if (!this.imageConfigured) {
            switch (this.scaleType) {
                case 1: 
                case 2: 
                case 3: {
                    this.stretchImage(width, height);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.cropImage(width, height);
                }
            }
            this.imageConfigured = true;
        }
    }

    public static final class Builder {
        private final Context c;
        private final int[] padding = new int[]{0, 0, 0, 0};
        private byte scaleType;
        private int gravity;
        private Bitmap image;

        public Builder(Context c) {
            this.c = c;
        }

        public Builder setImage(@DrawableRes int res) {
            return this.setImage(ContextCompat.getDrawable((Context)this.c, (int)res));
        }

        public Builder setImage(Drawable dr) {
            this.image = ImageStateDisplay.drawableToBitmap(dr);
            return this;
        }

        public Builder setImage(Bitmap bp) {
            this.image = bp;
            return this;
        }

        public Builder resizeImage(int widthDp, int heightDp) {
            if (this.image == null) {
                throw new NullPointerException("Please set image before calling resizeImage()!");
            }
            float density = this.c.getResources().getDisplayMetrics().density;
            int desiredWidth = (int)((float)widthDp * density);
            int desiredHeight = (int)((float)heightDp * density);
            this.image = Bitmap.createScaledBitmap((Bitmap)this.image, (int)desiredWidth, (int)desiredHeight, (boolean)false);
            return this;
        }

        public Builder setImageGravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder setScaleType(byte scaleType) {
            this.scaleType = scaleType;
            return this;
        }

        public Builder setPadding(int leftDp, int topDp, int rightDp, int bottomDp) {
            float density = this.c.getResources().getDisplayMetrics().density;
            this.padding[0] = (int)((float)leftDp * density);
            this.padding[1] = (int)((float)topDp * density);
            this.padding[2] = (int)((float)rightDp * density);
            this.padding[3] = (int)((float)bottomDp * density);
            return this;
        }

        public ImageStateDisplay build() {
            if (this.image == null) {
                throw new NullPointerException("Image cannot be null!");
            }
            ImageStateDisplay state = new ImageStateDisplay();
            state.setPadding(this.padding[0], this.padding[1], this.padding[2], this.padding[3]);
            state.scaleType = this.scaleType;
            state.imageGravity = this.gravity;
            state.image = this.image;
            return state;
        }
    }
}

