/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.bubbles;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.Px;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.tylersuehr.bubbles.CircleCountView;
import com.tylersuehr.bubbles.CircleImageView;
import com.tylersuehr.bubbles.R;

public class BubbleLayout
extends ViewGroup {
    private int bubbleSize;
    private int bubbleOffset;
    private int bubblePeek;
    private int bubbleBorderColor;
    private int bubbleBorderWidth;
    private int bubbleMargin;
    private int textColor;
    private boolean useOffset;
    private int excess = 0;

    public BubbleLayout(Context context) {
        this(context, null);
    }

    public BubbleLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BubbleLayout(Context c, AttributeSet attrs, int defStyleAttr) {
        super(c, attrs, defStyleAttr);
        float density = this.getResources().getDisplayMetrics().density;
        int DEFAULT_BUBBLE_SIZE = (int)(40.0f * density);
        int DEFAULT_BUBBLE_MARGIN = (int)(4.0f * density);
        int DEFAULT_BORDER_WIDTH = (int)(1.0f * density);
        int DEFAULT_BUBBLE_OFFSET = 2;
        int DEFAULT_BUBBLE_PEEK = 4;
        TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.BubbleLayout);
        this.bubbleSize = a.getDimensionPixelSize(R.styleable.BubbleLayout_bubbleSize, DEFAULT_BUBBLE_SIZE);
        this.bubbleOffset = this.bubbleSize / a.getInt(R.styleable.BubbleLayout_bubbleOffset, 2);
        this.bubblePeek = a.getInt(R.styleable.BubbleLayout_bubblePeek, 4);
        this.bubbleBorderWidth = a.getDimensionPixelSize(R.styleable.BubbleLayout_borderWidth, DEFAULT_BORDER_WIDTH);
        this.bubbleMargin = a.getDimensionPixelSize(R.styleable.BubbleLayout_bubbleMargin, DEFAULT_BUBBLE_MARGIN);
        this.bubbleBorderColor = a.getColor(R.styleable.BubbleLayout_borderColor, ContextCompat.getColor((Context)c, (int)R.color.default_circle_border_color));
        this.textColor = a.getColor(R.styleable.BubbleLayout_android_textColor, ContextCompat.getColor((Context)c, (int)R.color.default_circle_text_color));
        this.useOffset = a.getBoolean(R.styleable.BubbleLayout_useBubbleOffset, true);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        switch (widthMode) {
            case -2147483648: 
            case 0: {
                if (this.useOffset) {
                    widthSize = this.bubbleSize * this.getChildCount();
                    widthSize -= this.bubbleOffset * (this.getChildCount() - 1);
                    break;
                }
                widthSize = this.bubbleSize * this.getChildCount();
                widthSize += this.bubbleMargin * (this.getChildCount() - 1);
                break;
            }
            default: {
                widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            }
        }
        int childSpec = View.MeasureSpec.makeMeasureSpec((int)this.bubbleSize, (int)0x40000000);
        this.measureChildren(childSpec, childSpec);
        this.setMeasuredDimension(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000), childSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            int right;
            int left;
            View child = this.getChildAt(i);
            if (this.useOffset) {
                left = i * (i > 0 ? child.getMeasuredWidth() - this.bubbleOffset : child.getMeasuredWidth());
                right = left + child.getMeasuredWidth();
            } else {
                left = i * (child.getMeasuredWidth() + this.bubbleMargin);
                right = left + child.getMeasuredWidth() + this.bubbleMargin;
            }
            child.layout(left, 0, right, child.getMeasuredHeight());
        }
    }

    public void onViewAdded(View child) {
        if (!(child instanceof CircleImageView) && !(child instanceof CircleCountView)) {
            throw new IllegalArgumentException("View must be either CircleImageView or CircleCountView!");
        }
    }

    public void addBubble(@DrawableRes int res) {
        Drawable drawable = ContextCompat.getDrawable((Context)this.getContext(), (int)res);
        this.addBubble(drawable);
    }

    public void addBubble(Bitmap bitmap) {
        BitmapDrawable bpd = new BitmapDrawable(this.getResources(), bitmap);
        this.addBubble((Drawable)bpd);
    }

    public void addBubble(Drawable drawable) {
        if (this.getChildCount() >= this.bubblePeek) {
            CircleCountView countView;
            ++this.excess;
            if (this.excess > 1) {
                countView = (CircleCountView)this.getChildAt(this.bubblePeek);
            } else {
                countView = this.createThemedCount();
                this.addView(countView);
            }
            countView.setCount(this.excess);
        } else {
            this.addView((View)this.createThemedImage(drawable));
        }
    }

    public void clearBubbles() {
        this.excess = 0;
        this.removeAllViews();
    }

    public void setUseBubbleOffset(boolean useOffset) {
        this.useOffset = useOffset;
        this.invalidate();
    }

    public void setBubbleSize(int bubbleSize) {
        this.bubbleSize = bubbleSize;
        this.invalidate();
    }

    public void setBubblePeek(int bubblePeek) {
        this.bubblePeek = bubblePeek;
        this.invalidate();
    }

    public void setBubbleOffset(int bubbleOffset) {
        this.bubbleOffset = bubbleOffset;
        this.invalidate();
    }

    public void setBubbleMargin(int bubbleMargin) {
        this.bubbleMargin = bubbleMargin;
        this.invalidate();
    }

    public void setBubbleBorderWidth(@Px int width) {
        this.bubbleBorderWidth = width;
        this.invalidate();
    }

    public void setBubbleBorderColor(@ColorInt int color2) {
        this.bubbleBorderColor = color2;
        this.invalidate();
    }

    public void setBubbleBorderColorResource(@ColorRes int res) {
        this.setBubbleBorderColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public void setBubbleTextColor(@ColorInt int color2) {
        this.textColor = color2;
        this.invalidate();
    }

    public void setBubbleTextColorResource(@ColorRes int res) {
        this.setBubbleTextColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    private CircleCountView createThemedCount() {
        CircleCountView count = new CircleCountView(this.getContext());
        count.setLayoutParams(new ViewGroup.LayoutParams(this.bubbleSize, this.bubbleSize));
        count.setBorderColor(this.bubbleBorderColor);
        count.setBorderWidth(this.bubbleBorderWidth);
        count.setTextColor(this.textColor);
        return count;
    }

    private CircleImageView createThemedImage(Drawable dr) {
        CircleImageView image = new CircleImageView(this.getContext());
        image.setLayoutParams(new ViewGroup.LayoutParams(this.bubbleSize, this.bubbleSize));
        image.setBorderColor(this.bubbleBorderColor);
        image.setBorderWidth(this.bubbleBorderWidth);
        image.setImageDrawable(dr);
        return image;
    }
}

