/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.BeakerXClientManager;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.CommActions;
import com.twosigma.beakerx.widget.ValueWidget;
import com.twosigma.beakerx.widget.Widget;
import java.io.Serializable;
import java.util.HashMap;

public class Button
extends ValueWidget<Boolean> {
    public static final String VIEW_NAME_VALUE = "ButtonView";
    public static final String MODEL_NAME_VALUE = "ButtonModel";
    public static final String TOOLTIP = "tooltip";
    public static final String TAG = "tag";
    public static final String ICON = "icon";
    public static final String BUTTON_STYLE = "button_style";
    private String tooltip = "";
    private String tag;
    private String icon = "";
    private String button_style = "";
    private Widget.ActionPerformed actionPerformed = null;

    public Button() {
        this.getComm().addMsgCallbackList(this::handleOnClick);
        this.openComm();
    }

    @Override
    public void updateValue(Object value) {
    }

    @Override
    protected HashMap<String, Serializable> content(HashMap<String, Serializable> content) {
        super.content(content);
        content.put(TOOLTIP, (Serializable)((Object)this.tooltip));
        content.put(ICON, (Serializable)((Object)this.icon));
        content.put(BUTTON_STYLE, (Serializable)((Object)this.button_style));
        return content;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        this.sendUpdate(TOOLTIP, tooltip);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
        this.sendUpdate(TAG, tag);
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String tag) {
        this.icon = tag;
        this.sendUpdate(ICON, this.icon);
    }

    public void registerOnClick(Widget.ActionPerformed actionPerformed) {
        this.actionPerformed = actionPerformed;
    }

    private void handleOnClick(Message message) {
        this.handleCommEventSync(message, CommActions.CLICK, this::onClick);
    }

    public void onClick(HashMap content, Message message) {
        if (this.actionPerformed != null) {
            this.actionPerformed.executeAction(content, message);
        }
        if (this.getTag() != null && !this.getTag().isEmpty()) {
            BeakerXClientManager.get().runByTag(this.getTag());
        }
    }

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    @Override
    public Boolean getValueFromObject(Object input) {
        return this.getBoolean(input);
    }

    public String getButton_style() {
        return this.button_style;
    }

    public void setButton_style(String button_style) {
        this.button_style = button_style;
        this.sendUpdate(BUTTON_STYLE, button_style);
    }
}

