/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.kernel.CacheFolderFactory;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class EnvCacheFolderFactory
implements CacheFolderFactory {
    public static final CondaPrefix CONDA_PREFIX = new CondaPrefix();
    public static final VirtualEnvPrefix VIRTUAL_ENV_PREFIX = new VirtualEnvPrefix();
    private Path cache = null;
    private List<EnvPrefix> prefix;

    public EnvCacheFolderFactory() {
        this.prefix = Arrays.asList(CONDA_PREFIX, VIRTUAL_ENV_PREFIX);
    }

    EnvCacheFolderFactory(List<EnvPrefix> prefix) {
        this.prefix = prefix;
    }

    @Override
    public Path getCache() {
        if (this.cache == null) {
            this.cache = this.getOrCreateFile(this.getPrefix() + "/share/beakerx").toPath();
        }
        return this.cache;
    }

    private String getPrefix() {
        Optional<EnvPrefix> envPrefix = this.prefix.stream().filter(prefix -> prefix.get() != null && !prefix.get().isEmpty()).findFirst();
        return envPrefix.map(EnvPrefix::get).orElseGet(EnvCacheFolderFactory::getTmpDir);
    }

    private File getOrCreateFile(String pathToMavenRepo) {
        File theDir = new File(pathToMavenRepo);
        if (!theDir.exists()) {
            try {
                theDir.mkdirs();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return theDir;
    }

    static String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static class VirtualEnvPrefix
    implements EnvPrefix {
        private static final String VIRTUAL_ENV = "VIRTUAL_ENV";

        @Override
        public String get() {
            return System.getenv(VIRTUAL_ENV);
        }
    }

    public static class CondaPrefix
    implements EnvPrefix {
        private static final String CONDA_PREFIX = "CONDA_PREFIX";

        @Override
        public String get() {
            return System.getenv(CONDA_PREFIX);
        }
    }

    public static interface EnvPrefix {
        public String get();
    }
}

