/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorDeserializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)ColorDeserializer.class.getName());

    public ColorDeserializer(BeakerObjectConverter p) {
        p.addKnownBeakerType("Color");
    }

    @Override
    public boolean canBeUsed(JsonNode n) {
        return n.asText().matches("^#[0-9A-Fa-f]{8}$");
    }

    @Override
    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        Color o = null;
        try {
            long i = Long.parseLong(n.asText().substring(1), 16);
            o = new Color((int)(i >> 16 & 0xFFL), (int)(i >> 8 & 0xFFL), (int)(i & 0xFFL), (int)(i >> 24 & 0xFFL));
        }
        catch (Exception e) {
            logger.error("exception deserializing Color {}", (Object)e.getMessage());
        }
        return o;
    }
}

