/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public class HistogramReducer {
    private int rowLimit;
    private int numberOfRowsToDisplay;

    public HistogramReducer(int rowLimit, int numberOfRowsToDisplay) {
        this.rowLimit = rowLimit;
        this.numberOfRowsToDisplay = numberOfRowsToDisplay;
    }

    public List<List<Number>> limitData(List<Number> list) {
        return Collections.singletonList(list.subList(0, this.numberOfRowsToDisplay));
    }

    public List<List<Number>> limitListData(List<List<Number>> listData) {
        return listData.stream().map(x -> x.subList(0, x.size() >= this.rowLimit ? this.numberOfRowsToDisplay : x.size())).collect(Collectors.toList());
    }

    public OptionalInt totalPoints(List<List<Number>> listData) {
        return listData.stream().mapToInt(List::size).max();
    }
}

